package com.ejianc.foundation.supplier.service.impl;

import com.ejianc.foundation.supplier.bean.SupplerIncidentEntity;
import com.ejianc.foundation.supplier.mapper.SupplerIncidentMapper;
import com.ejianc.foundation.supplier.service.ISupplerIncidentService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
@Service("supplerIncidentService")
public class SupplerIncidentServiceImpl extends BaseServiceImpl<SupplerIncidentMapper, SupplerIncidentEntity> implements ISupplerIncidentService{

    @Autowired
    private SupplerIncidentMapper supplerIncidentMapper;

    /**
     * @param year
     * @return
     */
    @Override
    public List<SupplerIncidentEntity> getYearIncident(int year) {
        List<Long> list = supplerIncidentMapper.getYearOrgIds(year);
        if(ListUtil.isEmpty(list)){
            return null;
        }
        List<SupplerIncidentEntity> incidentEntities = new ArrayList<>();
        for (Long orgId : list) {
            List<SupplerIncidentEntity> incidentList = supplerIncidentMapper.getIncidentList(orgId, year);
            if(ListUtil.isEmpty(incidentList)){
                continue;
            }
            incidentEntities.addAll(incidentList);
        }
        return incidentEntities;
    }
}
