package com.ejianc.foundation.support.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 单据编码规则子元素
 */
@TableName("ejc_support_billcode_rule_attr")
public class BillCodeRuleAttrEntity extends BaseEntity {
    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 段号
     */
    @TableField(value = "elem_order")
    private int elemOrder;
    /**
     * 元素类型：
     * {'0':'流水号', '1':'常量', '2':'时间', '3': '随机字符串', '4': '实体属性值', '5': '自定义流水依据'}
     */
    @TableField(value = "elem_type")
    private String elemType;
    /**
     * 流水依据
     * 元素类型为时间时：{'0': '是,依据年度', '1':'是,依据月度', '2':'是,依据每日'}
     * 其他：{'0':'非流水依据', '1':'是流水依据'}
     */
    @TableField(value = "elem_isrefer")
    private String elemIsRefer;
    /**
     * 元素长度
     */
    @TableField(value = "elem_length")
    private int elemLength;
    /**
     * 元素值
     */
    @TableField(value = "elem_value")
    private String elemValue;

    /**
     * 单据编码规则ID
     */
    @TableField(value = "billcode_rule_Id")
    private Long billCodeRuleId;

    /**
     * 日期格式数据格式化方式
     */
    @TableField(value = "date_elem_display_format")
    private String dateElemDisplayFormat;

    /**
     * 填充方式
     */
    @TableField(value = "fill_style")
    private int fillStyle;

    /**
     * 填充内容
     */
    @TableField(value = "fill_sign")
    private String fillSign;

    public int getElemOrder() {
        return elemOrder;
    }

    public void setElemOrder(int elemOrder) {
        this.elemOrder = elemOrder;
    }

    public String getElemType() {
        return elemType;
    }

    public void setElemType(String elemType) {
        this.elemType = elemType;
    }

    public String getElemIsRefer() {
        return elemIsRefer;
    }

    public void setElemIsRefer(String elemIsRefer) {
        this.elemIsRefer = elemIsRefer;
    }

    public int getElemLength() {
        return elemLength;
    }

    public void setElemLength(int elemLength) {
        this.elemLength = elemLength;
    }

    public String getElemValue() {
        return elemValue;
    }

    public void setElemValue(String elemValue) {
        this.elemValue = elemValue;
    }

    public Long getBillCodeRuleId() {
        return billCodeRuleId;
    }

    public void setBillCodeRuleId(Long billCodeRuleId) {
        this.billCodeRuleId = billCodeRuleId;
    }

    public String getDateElemDisplayFormat() {
        return dateElemDisplayFormat;
    }

    public void setDateElemDisplayFormat(String dateElemDisplayFormat) {
        this.dateElemDisplayFormat = dateElemDisplayFormat;
    }

    public int getFillStyle() {
        return fillStyle;
    }

    public void setFillStyle(int fillStyle) {
        this.fillStyle = fillStyle;
    }

    public String getFillSign() {
        return fillSign;
    }

    public void setFillSign(String fillSign) {
        this.fillSign = fillSign;
    }
}
