package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.service.IFinanceAccountService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.FinanceAccountEntity;
import com.ejianc.foundation.support.vo.FinanceAccountVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 银行账户
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("financeAccount")
public class FinanceAccountController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BANK_ACCOUNT";//此处需要根据实际修改

    @Autowired
    private IFinanceAccountService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinanceAccountVO> saveOrUpdate(@RequestBody FinanceAccountVO saveOrUpdateVO) {
    	FinanceAccountEntity entity = BeanMapper.map(saveOrUpdateVO, FinanceAccountEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	FinanceAccountVO vo = BeanMapper.map(entity, FinanceAccountVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceAccountVO> queryDetail(Long id) {
    	FinanceAccountEntity entity = service.selectById(id);
    	FinanceAccountVO vo = BeanMapper.map(entity, FinanceAccountVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinanceAccountVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FinanceAccountVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FinanceAccountVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinanceAccountVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountName");
        fuzzyFields.add("accountNum");
        fuzzyFields.add("accountBankName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<FinanceAccountEntity> page = service.queryPage(param,false);
        IPage<FinanceAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinanceAccountVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "finance-import.xlsx", "导入银行账户");
    }
    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<FinanceAccountVO> successList = new ArrayList<>();
            List<FinanceAccountVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 4) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            List<Integer> orgTypeList = new ArrayList<>();
            orgTypeList.addAll(Arrays.asList(1,2,3,4));
            CommonResponse<List<OrgVO>> orgByList = iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), orgTypeList,null);
            Map<String, Long> orgMap =new HashMap<>();
            if (orgByList.isSuccess()){
                 orgMap = orgByList.getData().stream().collect(Collectors.toMap(OrgVO::getName, OrgVO::getId,(e1,e2)->e2));
            }else {
                throw new BusinessException("获取组织信息失败！");
            }
            for (int i = 0; i < result.size(); i++) {
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                FinanceAccountVO financeAccountVO = new FinanceAccountVO();
                // 内部单位
                String orgName = row.get(0).trim();
                if (StringUtils.isNotBlank(orgName)) {
                    Long orgId = orgMap.get(orgName);
                    if (orgId != null) {
                        financeAccountVO.setInnerUnitId(orgId);
                        financeAccountVO.setInnerUnitName(orgName);
                    } else {
                        errMsg.append("`内部单位不存在请重新输入`");
                    }
                } else {
                    errMsg.append("`内部单位未填写`");
                }

                // 账户名
                String accountName = row.get(1).trim();
                if (StringUtils.isNotBlank(accountName)) {
                    financeAccountVO.setAccountName(accountName);
                } else {
                    errMsg.append("`账户名未填写`");
                }
                //银行账户
                String accountNum = row.get(2).trim();
                if (StringUtils.isNotBlank(accountNum)) {
                    financeAccountVO.setAccountNum(accountNum);
                } else {
                    errMsg.append("`银行账户未填写`");
                }
                //开户行
                String accountBankName = row.get(3).trim();
                if (StringUtils.isNotBlank(accountBankName)) {
                    financeAccountVO.setAccountBankName(accountBankName);
                }
                financeAccountVO.setEnabledStatus(1);
                financeAccountVO.setEnabledStatusName("已启用");
                financeAccountVO.setErrMsg(errMsg.toString());
                if (StringUtils.isNotBlank(financeAccountVO.getErrMsg())) {
                    errorList.add(financeAccountVO);
                } else {
                    successList.add(financeAccountVO);
                }
            }


            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, FinanceAccountVO.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<FinanceAccountVO> accbookVOS) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId, accbookVOS.size());
        List<String> billCodeList = new ArrayList<>();
        if (billCode.isSuccess()) {
            billCodeList = billCode.getData();
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        for (int i = 0; i < accbookVOS.size(); i++) {
            accbookVOS.get(i).setBillCode(billCodeList.get(i));
        }
        logger.info("billcode----------------："+ JSONObject.toJSONString(billCode));
        service.saveBatch(BeanMapper.mapList(accbookVOS, FinanceAccountEntity.class));
        return CommonResponse.success("导入成功");
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountName");
        fuzzyFields.add("accountNum");
        fuzzyFields.add("accountBankName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<FinanceAccountEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<FinanceAccountVO> financeAccountVOS = BeanMapper.mapList(list, FinanceAccountVO.class);
        for (FinanceAccountVO financeAccountVO : financeAccountVOS) {
            if (financeAccountVO.getEnabledStatus()==1){
                financeAccountVO.setEnabledStatusName("已启用");
            }else {
                financeAccountVO.setEnabledStatusName("已停用");
            }
        }
        beans.put("records", financeAccountVOS);
        ExcelExport.getInstance().export("BankAccount-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/updateEnableStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceAccountVO> updateEnableStatus(Long id, Integer status) {
        if (id != null) {
            LambdaUpdateWrapper<FinanceAccountEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(FinanceAccountEntity::getId, id);
            updateWrapper.set(FinanceAccountEntity::getEnabledStatus, status);
            service.update(updateWrapper);
        }

        return CommonResponse.success("更新启用状态成功！");
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refBankAccountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FinanceAccountVO>> refBankAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                      String condition,
                                                                      String searchObject,
                                                                      String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().addAll(Arrays.asList("accountNum","accountName","accountBankName","billCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabledStatus", new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FinanceAccountEntity> page = service.queryPage(param,false);
        IPage<FinanceAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinanceAccountVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
