package com.ejianc.foundation.support.service.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.DefdocEntity;
import com.ejianc.foundation.support.mapper.DefdocMapper;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DefdocServiceImpl extends BaseServiceImpl<DefdocMapper, DefdocEntity> implements IDefdocService {

	@Override
	public DefdocVO queryDetail(Long id) {
		Map<String, LinkedHashMap<String, String>> subOrderMap = new HashMap<>();
		LinkedHashMap<String, String> sub = new LinkedHashMap<>();
		sub.put("sequence", QueryParam.ASC);
		subOrderMap.put("attrs",sub);
		DefdocEntity entity = super.selectById(id,subOrderMap);
		if (entity != null) {
			return BeanMapper.map(entity, DefdocVO.class);
		}
		return null;
	}

	@Override
	public void delete(List<Long> ids) {
		super.removeByIds(ids);
	}

	@Override
	public DefdocVO queryUniqueByCode(String defdocCode) {
		QueryWrapper<DefdocEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("code", defdocCode);
		List<DefdocEntity> entities = baseMapper.selectList(wrapper);
		if (entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), DefdocVO.class);
		}
		return null;
	}

	/**
	 * 根据档案编号查询bean
	 *
	 * @param defdocCode
	 * @return
	 */
	@Override
	public List<DefdocVO> queryByCode(String defdocCode) {
		QueryWrapper<DefdocEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("code", defdocCode);
		List<DefdocEntity> entities = baseMapper.selectList(wrapper);
		if (entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, DefdocVO.class);
		}
		return null;
	}

	@Override
	public List<DefdocVO> queryUniqueByCodeList(List<String> defdocTypeCodeList) {
		QueryWrapper<DefdocEntity> wrapper = new QueryWrapper<>();
		wrapper.in("code", defdocTypeCodeList);
		List<DefdocEntity> entities = baseMapper.selectList(wrapper);
		if (entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, DefdocVO.class);
		}
		return null;
	}

}
