package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import org.apache.commons.lang.StringUtils;

/**
 * 元素处理器--自定义流水依据
 */
public class CustomSnReferElemProcessor implements IElemProcessor {
    @Override
    public int getCanProcElemType() {
        return 5;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        String elemSNRefer = "";
        if(null != billCodeBillVO) {
            elemSNRefer = billCodeBillVO.getCustomSnReferMark();
        }
        String elemSNReferDesc = "";
        if (StringUtils.isNotBlank(elemSNRefer)) {
            elemSNRefer = "^custom^" + elemSNRefer;
            elemSNReferDesc = "#custom#" + elemSNRefer.length() + "|";
        }
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemSNRefer(elemSNRefer);
        eleminfo.setElemSNReferDesc(elemSNReferDesc);
        eleminfo.setElemLength(elemvo.getElemLength());
        eleminfo.setSysTimeElem(false);
        return eleminfo;
    }
}
