package com.ejianc.foundation.dataModel.service.impl;

import com.ejianc.foundation.dataModel.bean.DataModelTenantColumnEntity;
import com.ejianc.foundation.dataModel.mapper.DataModelTenantColumnMapper;
import com.ejianc.foundation.dataModel.service.IDataModelTenantColumnService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据模型租户字段
 * 
 * @author generator
 * 
 */
@Service("dataModelTenantColumnService")
public class DataModelTenantColumnServiceImpl extends BaseServiceImpl<DataModelTenantColumnMapper, DataModelTenantColumnEntity> implements IDataModelTenantColumnService{

    @Override
    public DataModelTenantColumnEntity queryCusColumnByColumnId(Long columnId) {

        QueryParam param = new QueryParam();
        param.getParams().put("columnId",new Parameter(QueryParam.EQ,columnId));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<DataModelTenantColumnEntity> list = queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
}
