package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.service.IMaterialCategoryCr12gService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("rawtypes")
@RestController
@RequestMapping("/materialCr12g/category/")
public class MaterialCategoryCr12gController implements Serializable {

	private static final long serialVersionUID = 1L;

	@Autowired
	private IMaterialCategoryCr12gService materialCategoryCr12gService;

	/**
	 * 分类树参照
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "materialTreeRef", method = RequestMethod.GET)
	@ResponseBody
	public List<Map<String, Object>> materialTreeRef(
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText) {
		Map<String,Object> params = new HashMap<>();
		List<MaterialCategoryVO> dataList = null;
		if(StringUtils.isNotBlank(searchText)) {
			params.put("searchText", searchText);

		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		dataList = materialCategoryCr12gService.queryListTree(params);
		List<Map> map = BeanMapper.mapList(dataList, Map.class);
		return ResultAsTree.createTreeData(map);
	}


	/**
	 * 参照异步（懒加载）树----物资分类树
	 * 
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "/lazyMaterialCategoryTree", method = RequestMethod.GET)
	@ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition,
    		@RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        Integer assetType = null;
        try {
        	if(StringUtils.isNotEmpty(condition)){
				Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
				assetType = conditionMap.get("assetType") == null ? null : Integer.valueOf(conditionMap.get("assetType").toString());

			}

        	if(StringUtils.isNotBlank(searchText)) {
				Map<String,Object> params = new HashMap<>();
        		params.put("searchText", searchText);
            	params.put("tenantId", InvocationInfoProxy.getTenantid());

				if (null != assetType) {
					params.put("assetType", assetType);
				}
            	dataList = materialCategoryCr12gService.queryListTree(params);
        	}else{
				dataList = materialCategoryCr12gService.queryListByPidAndAssetType(pid, assetType);
        	}
    		List<Map> map = BeanMapper.mapList(dataList, Map.class);
    		return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }

}
