package com.ejianc.foundation.support.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 参照管理实体
 */
@TableName("ejc_support_refer")
public class ReferEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
     * 参照编码
     */
    @TableField(value = "ref_code")
    private String refCode;

	/**
     * 参照名称
     */
    @TableField(value = "ref_name")
    private String refName;

	/**
     * 参照类型
     */
    @TableField(value = "ref_type")
    private String refType;

	/**
     * 保存聚合参照的聚合参照编码，逗号分隔
     */
    @TableField(value = "multi_ref_type")
    private String multiRefCode;


	/**
     * 保存聚合参照的聚合参照名称，逗号分隔
     */
    @TableField(value = "multi_ref_name")
    private String multiRefName;

	/**
     * 所属模块
     */
    @TableField(value = "refer_module")
    private Long referModule;
    
	/**
     * 是否启用基准地址
     */
    @TableField(value = "enable_base_url")
    private boolean enableBaseUrl;
    
	/**
     * 树数据地址
     */
    @TableField(value = "treerelyurl")
    private String treerelyurl;

	/**
     * 数据地址
     */
    @TableField(value = "dataurl")
    private String dataurl;

	/**
     * 请求方式
     */
    @TableField(value = "query_method")
    private String queryMethod;

	/**
     * ID关键字
     */
    @TableField(value = "id_field")
    private String idField;

	/**
     * 编号关键字
     */
    @TableField(value = "code_field")
    private String codeField;

	/**
     * 名称关键字
     */
    @TableField(value = "name_field")
    private String nameField;

	/**
     * 默认分页条数
     */
    @TableField(value = "page_size")
    private String pageSize;
    
	/**
     * 分类关键字（即选中树节点查询右侧树时带入的列）
     */
    @TableField(value = "relyfield")
    private String relyfield;

	/**
     * 备注
     */
    @TableField(value = "remarks")
    private String remarks;

	/**
     * 参照树显示的字段，可以多个，以逗号分隔
     */
    @TableField(value = "tree_show_fields")
    private String treeShowFields;

	public Long getReferModule() {
		return referModule;
	}

	public void setReferModule(Long referModule) {
		this.referModule = referModule;
	}

	public String getIdField() {
		return idField;
	}

	public void setIdField(String idField) {
		this.idField = idField;
	}

	public String getCodeField() {
		return codeField;
	}

	public void setCodeField(String codeField) {
		this.codeField = codeField;
	}

	public String getNameField() {
		return nameField;
	}

	public void setNameField(String nameField) {
		this.nameField = nameField;
	}

	public String getPageSize() {
		return pageSize;
	}

	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getRefCode() {
		return refCode;
	}

	public void setRefCode(String refCode) {
		this.refCode = refCode;
	}

	public String getRefName() {
		return refName;
	}

	public void setRefName(String refName) {
		this.refName = refName;
	}

	public String getRefType() {
		return refType;
	}

	public void setRefType(String refType) {
		this.refType = refType;
	}

	public String getTreerelyurl() {
		return treerelyurl;
	}

	public void setTreerelyurl(String treerelyurl) {
		this.treerelyurl = treerelyurl;
	}

	public String getDataurl() {
		return dataurl;
	}

	public void setDataurl(String dataurl) {
		this.dataurl = dataurl;
	}

	public String getQueryMethod() {
		return queryMethod;
	}

	public void setQueryMethod(String queryMethod) {
		this.queryMethod = queryMethod;
	}

	public String getRelyfield() {
		return relyfield;
	}

	public void setRelyfield(String relyfield) {
		this.relyfield = relyfield;
	}

	public boolean getEnableBaseUrl() {
		return enableBaseUrl;
	}

	public void setEnableBaseUrl(boolean enableBaseUrl) {
		this.enableBaseUrl = enableBaseUrl;
	}

	public String getMultiRefCode() {
		return multiRefCode;
	}

	public void setMultiRefCode(String multiRefCode) {
		this.multiRefCode = multiRefCode;
	}

	public String getMultiRefName() {
		return multiRefName;
	}

	public void setMultiRefName(String multiRefName) {
		this.multiRefName = multiRefName;
	}

	public String getTreeShowFields() {
		return treeShowFields;
	}

	public void setTreeShowFields(String treeShowFields) {
		this.treeShowFields = treeShowFields;
	}
}
