package com.ejianc.foundation.supplier.service.impl;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierPunishEntity;
import com.ejianc.foundation.supplier.bean.SupplierRmBlackEntity;
import com.ejianc.foundation.supplier.service.ISupplierPunishService;
import com.ejianc.foundation.supplier.service.ISupplierRmBlackService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("supplierRmBlack") 
public class SupplierRmBlackBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISupplierPunishService service;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISupplierRmBlackService rmBlackService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplierRmBlackEntity entity = rmBlackService.selectById(billId);
		if(entity==null){
			return CommonResponse.error("处置单不存在！");
		}
		SupplierEntity supplier = supplierService.selectById(entity.getSupplyId());
		if(supplier==null){
			return CommonResponse.error("被处置的供应商不存在！");
		}
		CommonResponse<OrgVO> org = iOrgApi.getOneById(entity.getApplyOrgId());
		if(!org.isSuccess()){
			return CommonResponse.error("获取组织信息失败！");
		}
		if(org.getData().getOrgType()==1){
			/** 集团 直接更细到供应商信息中 全部拉黑 */
			supplier.setGroupBlack(false);
			supplier.setGroupLastTime(null);
			supplierService.saveOrUpdate(supplier, false);
		}else {
			/** 其他组织 ， 直接更新到供应商拉黑单位*/
			if(Objects.equals(supplier.getBlackOrgIds(),entity.getApplyOrgId().toString())){
				/** 就是当前组织拉黑的，直接移除 即可*/
				supplier.setBlackOrgIds("");
				supplier.setBlackOrgNames("");
			}else {
				supplier.setBlackOrgIds(supplier.getBlackOrgIds().replace(","+entity.getApplyOrgId().toString(),""));
				supplier.setBlackOrgNames(supplier.getBlackOrgNames().replace(","+entity.getApplyOrg(),""));
			}
			supplierService.saveOrUpdate(supplier, false);
		}
		QueryParam queryParam = QueryParam.getInstance();
		queryParam.getParams().put("supplyId", new Parameter(QueryParam.EQ,supplier.getId()));
		queryParam.getParams().put("applyOrgId", new Parameter(QueryParam.EQ,entity.getApplyOrgId()));
		queryParam.getParams().put("pushState", new Parameter(QueryParam.EQ,"2"));
		List<SupplierPunishEntity> punishList = service.queryList(queryParam, false);
		if(ListUtil.isNotEmpty(punishList)){
			for (SupplierPunishEntity punish : punishList) {
				punish.setPushState("4");
				punish.setRmCode(entity.getCode());
				punish.setRmId(entity.getId());
				service.saveOrUpdate(punish, false);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
