package com.ejianc.foundation.support.service;

import java.util.List;

import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IDefdocDetailService extends IBaseService<DefdocDetailEntity>  {

	/**
	 * 根据编码规则Ids 查询明细list
	 * 
	 * @param ids
	 * @return
	 */
	List<DefdocDetailVO> queryListByDefdocId(List<Long> ids);

	/**
	 * 根据 自定义档案id 查询自定义档案项
	 *
	 * @param defId
	 * @param tenantId
	 * @return
	 */
	List<DefdocDetailVO> getDefDocByDefId(Long defId);

	/**
	 * 根据 自定义档案id 查询自定义档案项
	 *
	 * @param defId
	 * @param tenantId
	 * @return
	 */
	List<DefdocDetailVO> getDefDocByDefId(Long defId,Long tenantId);

	/**
	 * 根据主键查询规则明细bean
	 * 
	 * @param id
	 * @return
	 */
	DefdocDetailVO queryDetail(Long id);

	/**
	 * 删除
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据父Id查询列表
	 * 
	 * @param id
	 * @return
	 */
	List<DefdocDetailVO> queryListByPid(Long id);

	/**
	 * 更新状态
	 */
	void updateEnabled(DefdocDetailVO defdocDetailVo);

	/**
	 * 根据自定义档案名称查询自定义档案
	 * 
	 * @param code
	 * @return
	 */
	DefdocDetailVO queryDetailByName(String name);

	/**
	 * 根据自定义档案名称查询自定义档案
	 *
	 * @param code
	 * @return
	 */
	DefdocDetailVO getDefDocByName(Long defDocId,String name);

	/**
	 * 查询档案明细
	 * 
	 * @param queryParam
	 * @return
	 */
	List<DefdocDetailEntity> queryList(QueryParam queryParam);

	/**
	 * 保存实体
	 * 
	 * @param defdocDetailEntity
	 */
	void saveDetail(DefdocDetailEntity defdocDetailEntity);

	/**
	 * 修改实体
	 * 
	 * @param defdocDetailEntity
	 */
	void updateDetail(DefdocDetailEntity defdocDetailEntity);

    void initDefdoc();

    List<DefdocDetailVO> queryDetailListByDetailIds(List<Long> detailIds);
}
