package com.ejianc.foundation.bill.controller;

import java.io.Serializable;

import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.bill.bean.BillRoleEntity;
import com.ejianc.foundation.bill.service.IBillRoleService;
import com.ejianc.foundation.bill.vo.BillRoleVO;

/**
 * 单据制度说明
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billRole")
public class BillRoleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillRoleService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillRoleVO> saveOrUpdate(@RequestBody BillRoleVO saveOrUpdateVO) {
    	BillRoleEntity entity = BeanMapper.map(saveOrUpdateVO, BillRoleEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getBillTypeId()));
        if(CollectionUtils.isNotEmpty(service.queryList(param,false))){
            return CommonResponse.error("该单据类型已存在制度说明，请换一个单据类型！");
        }
    	service.saveOrUpdate(entity, false);
    	BillRoleVO vo = BeanMapper.map(entity, BillRoleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillRoleVO> queryDetail(Long id) {
    	BillRoleEntity entity = service.selectById(id);
    	BillRoleVO vo = BeanMapper.map(entity, BillRoleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 租户查询自己的单据制度详情
     * 组件使用
     * */
    @RequestMapping(value = "/findByBillTypeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillRoleVO> findByBillTypeId(String billTypeId) {
        if(StringUtils.isEmpty(billTypeId)){
            return CommonResponse.success();
        }
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeId",new Parameter(QueryParam.EQ,billTypeId));
        List<BillRoleEntity> entities = service.queryList(param,false);
        if(ListUtil.isEmpty(entities)){
            return CommonResponse.success();
        }
        BillRoleEntity entity = entities.get(0);
        BillRoleVO vo = BeanMapper.map(entity, BillRoleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillRoleVO> vos) {
        service.removeByIds(vos.stream().map(BillRoleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillRoleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("billTypeCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BillRoleEntity> page = service.queryPage(param,false);
        IPage<BillRoleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillRoleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeCode");
        fuzzyFields.add("billTypeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BillRoleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BillRole-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBillRoleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BillRoleVO>> refBillRoleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BillRoleEntity> page = service.queryPage(param,false);
        IPage<BillRoleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillRoleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
