package com.ejianc.foundation.billcode;

import com.ejianc.foundation.billcode.elemproc.BillCodeElemProcEngine;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeInfo;
import com.ejianc.foundation.billcode.engine.BillCodeEngine;
import com.ejianc.foundation.billcode.engine.BillcodeSNReferProducer;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.lock.IBillCodeEngineLock;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractBillCodeProvider {

    private Logger logger = LoggerFactory.getLogger(AbstractBillCodeProvider.class);
    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private BillcodeSNReferProducer billcodeSNReferProducer;

    protected abstract IBillCodeEngineLock getBillCodeEngineLock();
    protected abstract IBillCodeEngineService getBillcodePesisServ();
    protected abstract BillCodeGeneratorNeedAddTransaction getBillCodeGenerator();

    public String getBillCode(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, Long tenantId) throws BillCodeException {
        return this.getBatchBillCodes(rulevo, billvo, externalElemInfo, randomCodePara, 1, tenantId)[0];
    }
    public String[] getBillCode(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, int count, Long tenantId) throws BillCodeException {
        return this.getBatchBillCodes(rulevo, billvo, externalElemInfo, randomCodePara, count, tenantId);
    }

    private String[] getBatchBillCodes(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, int num, Long tenantId) throws BillCodeException {
        if(null == rulevo) {
            return null;
        } else {
            String[] billCode = null;
            BillCodeEngine engine = this.getBillcodeEngine(rulevo, billvo, externalElemInfo);
            IBillCodeEngineLock lock = this.getBillCodeEngineLock();
            boolean locked = false;

            if(2 == lock.getEngineLockType()) {
                try {
                    // 记录起始时间
                    long start = System.currentTimeMillis();
                    locked = lock.lock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
                    // 记录结束时间
                    long end = System.currentTimeMillis();
                    logger.info(Thread.currentThread().getId() + "xxxxxx加锁耗时" + (end - start));
                    if (locked) {
                        billCode = this.getBillCodeGenerator().getBillCode(engine, lock, num, false, tenantId);
                        logger.info(Thread.currentThread().getId() + "xxxxxxx单据号获取" + (System.currentTimeMillis() - end));
                    } else {
                        logger.info(Thread.currentThread().getId() + "单据号加锁失败，可能是并发过大");
                        throw new BillCodeException(Thread.currentThread().getId() + "单据号加锁失败，可能是并发过大请稍后重试!");
                    }

                } catch (BillCodeException e) {
                    logger.error("生成单据编码出错", e);
                    throw new BillCodeException(e.getMessage());
                } finally {
                    if (locked) {
                        // 记录起始时间
                        long start = System.currentTimeMillis();
                        lock.unlock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
                        // 记录结束时间
                        long end = System.currentTimeMillis();
                        logger.info(Thread.currentThread().getId() + "xxxxxx解锁耗时" + (end - start));
                    }
                }
            } else {
                billCode = this.getBillCodeGenerator().getBillCode(engine, lock, num, false, tenantId);
            }

            return billCode;
        }
    }

    private BillCodeEngine getBillcodeEngine(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo) throws BillCodeException {
        BillCodeInfo info = new BillCodeInfo(externalElemInfo);
        BillCodeElemProcEngine elemEngine  = BillCodeElemProcEngine.getInstance();
        BillCodeInfo innerInfo = elemEngine.procElems(rulevo, billvo);
        info.addBillCodeInfo(innerInfo);
        info.setSerialNumInfo(innerInfo.getSerialNumInfo());
        info.setSysDateRefInfos(innerInfo.getSysDateRefInfos());
        info.setPk_bilcodebase(rulevo.getId().toString());
        //自动填充
        info.setIsautofill(true);
        //填充0
        info.getSerialNumInfo().setAppendZero(true);
        return new BillCodeEngine(info, this.getBillcodePesisServ(), cacheManager, billcodeSNReferProducer);
    }

}
