package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;

import java.util.Random;

/**
 * 元素处理器--随机字符串
 */
public class RandomStrElemProcessor implements IElemProcessor {
    @Override
    public int getCanProcElemType() {
        return 3;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemValue(getCharAndNumr(elemvo.getElemLength()));
        eleminfo.setElemLength(elemvo.getElemLength());
        return eleminfo;
    }

    private static String getCharAndNumr(int length) {
        String val = "";
        Random random = new Random();

        for (int i = 0; i < length; ++i) {
            String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char) (choice + random.nextInt(26));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                val = val + String.valueOf(random.nextInt(10));
            }
        }

        return val;
    }
}
