package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeEngineContext;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.billcode.util.BillCodeProcessUtils;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;

/**
 * 元素处理器--时间
 */
public class SysTimeElemProcessor implements IElemProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SysTimeElemProcessor.class);
    @Override
    public int getCanProcElemType() {
        return 2;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        Date sysdate = BillCodeEngineContext.getInstance().getSysDateImp().getDate();
        logger.info("-----------------单据编码规则时间------------");
        logger.info("sysdate:{}",sysdate);
        String elemSNRefer = BillCodeProcessUtils.getDateElemSNRefer(Integer.valueOf(elemvo.getElemIsRefer()), sysdate);
        logger.info("elemSNRefer:{}",elemSNRefer);
        String elemSNReferDesc = "";
        if (!elemSNRefer.equals("")) {
            elemSNRefer = "^sysdate^" + elemSNRefer;
            elemSNReferDesc = "#date#" + elemSNRefer.length() + "|";
        }

        String elemProcedValue = BillCodeProcessUtils.formatDate(sysdate, elemvo.getDateElemDisplayFormat());
        logger.info("elemProcedValue:{}",elemProcedValue);
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemSNRefer(elemSNRefer);
        eleminfo.setElemSNReferDesc(elemSNReferDesc);
        eleminfo.setElemValue(elemProcedValue.trim().substring(0, elemvo.getElemLength()));
        eleminfo.setElemLength(elemvo.getElemLength());
        eleminfo.setSysTimeElem(true);
        return eleminfo;
    }
}
