package com.ejianc.foundation.billcode.service.impl;

import com.ejianc.foundation.billcode.AbstractBillCodeProvider;
import com.ejianc.foundation.billcode.BillCodeGeneratorNeedAddTransaction;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.lock.IBillCodeEngineLock;
import com.ejianc.foundation.billcode.service.IBillCodeProvider;
import com.ejianc.foundation.billcode.transgetbillcode.BillCodeGeneratorWithTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("provider")
@Transactional
public class BillCodeProviderServiceImpl extends AbstractBillCodeProvider implements IBillCodeProvider {

    @Autowired
    private IBillCodeEngineService billcodePesisServ;
    @Autowired
    private IBillCodeEngineLock redisLock;
    @Autowired
    private BillCodeGeneratorWithTransaction transGenerator;

    @Override
    public BillCodeGeneratorNeedAddTransaction getBillCodeGenerator() {
        return this.transGenerator;
    }

    public void setTransGenerator(BillCodeGeneratorWithTransaction transGenerator) {
        this.transGenerator = transGenerator;
    }

    @Override
    public IBillCodeEngineService getBillcodePesisServ() {
        return this.billcodePesisServ;
    }

    public void setBillcodePesisServ(IBillCodeEngineService billcodePesisServ) {
        this.billcodePesisServ = billcodePesisServ;
    }

    @Override
    protected IBillCodeEngineLock getBillCodeEngineLock() {
        return this.redisLock;
    }
}
