package com.ejianc.foundation.init.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.init.mapper.InitMapper;
import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Transactional
public class InitServiceImpl implements InitService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    InitMapper initMapper;
    @Autowired
    ISupplierService iSupplierService;
    @Autowired
    private ICustomerCategoryService iCustomerCategoryService;
    @Autowired
    private ICustomerService iCustomerService;


    @Override
    public void initData(EnterpriseInitVO vo) {
        logger.info("初始化租户数据开始-------{}", JSONObject.toJSONString(vo));
        if(vo.getTenantId() == null){
            throw new BusinessException("租户id不存在!");
        }
        //建表
        initMapper.createThreeTables(vo.getTenantId());
        //创建客户
        CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
        customerCategoryEntity.setId(IdWorker.getId());
        customerCategoryEntity.setName("内部客户");
        customerCategoryEntity.setCode("CC-"+customerCategoryEntity.getId());
        customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        customerCategoryEntity.setSequence(1);
        customerCategoryEntity.setDescription("系统创建！");
        customerCategoryEntity.setTenantId(vo.getTenantId());
        iCustomerCategoryService.saveOrUpdate(customerCategoryEntity,false);
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setId(IdWorker.getId());
        customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
        customerEntity.setCode("CUS-"+customerEntity.getId());
        customerEntity.setName(vo.getName());
        customerEntity.setCategoryId(customerCategoryEntity.getId());
        customerEntity.setTenantId(vo.getTenantId());
        customerEntity.setLegal(vo.getLegalName());
        customerEntity.setTelephone(vo.getTelephone());
        customerEntity.setDescription("系统创建!");
        iCustomerService.saveOrUpdate(customerEntity,false);
        //创建供应商
        SupplierEntity supplierEntity = new SupplierEntity();
        supplierEntity.setId(IdWorker.getId());
        supplierEntity.setCode("SP-"+supplierEntity.getId());
        supplierEntity.setTenantId(vo.getTenantId());
        supplierEntity.setName(vo.getName());
        iSupplierService.saveOrUpdate(supplierEntity,false);
    }

    @Override
    public void rollBack(Long tenantId) {
        if(tenantId == null){
            throw new BusinessException("租户id不存在!");
        }
        initMapper.dropThreeTables(tenantId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        List<SupplierEntity> supplierEntityList = iSupplierService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(supplierEntityList)){
            iSupplierService.removeByIds(supplierEntityList.stream().map(SupplierEntity::getId).collect(Collectors.toList()));
        }
        List<CustomerCategoryEntity> customerCategoryEntities = iCustomerCategoryService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(customerCategoryEntities)){
            iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(CustomerCategoryEntity::getId).collect(Collectors.toList()));
        }
        List<CustomerEntity> customerEntities = iCustomerService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(customerEntities)){
            iCustomerService.removeByIds(customerEntities.stream().map(CustomerEntity::getId).collect(Collectors.toList()));
        }

    }
    
    @Override
    public void initDataByParams(EnterpriseInitVO vo) {
        if(vo.getTenantId() == null){
            throw new BusinessException("租户id不存在!");
        }
        if(vo.getInitData()!=null){
            Map<String,Object> map = new HashMap<>();
            if(vo.getInitData().contains("all")){
                map.put("material", "material");
            }else{
            	if(vo.getInitData().contains("material")){
                    map.put("material", "material");
            	}
            }
        	if(map!=null&&map.size()>0){
                //建表
        		initMapper.createThreeTablesByParams(map);
        	}
        	if(vo.getInitData().contains("customer")||vo.getInitData().contains("all")){
                //创建客户
                CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
                customerCategoryEntity.setId(IdWorker.getId());
                customerCategoryEntity.setName("内部客户");
                customerCategoryEntity.setCode("CC-"+customerCategoryEntity.getId());
                customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
                customerCategoryEntity.setSequence(1);
                customerCategoryEntity.setDescription("系统创建！");
                customerCategoryEntity.setTenantId(vo.getTenantId());
                iCustomerCategoryService.saveOrUpdate(customerCategoryEntity,false);
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setId(IdWorker.getId());
                customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
                customerEntity.setCode("CUS-"+customerEntity.getId());
                customerEntity.setName(vo.getName());
                customerEntity.setCategoryId(customerCategoryEntity.getId());
                customerEntity.setTenantId(vo.getTenantId());
                customerEntity.setLegal(vo.getLegalName());
                customerEntity.setTelephone(vo.getTelephone());
                customerEntity.setDescription("系统创建!");
                iCustomerService.saveOrUpdate(customerEntity,false);
        	}
        	if(vo.getInitData().contains("supplier")||vo.getInitData().contains("all")){
        		//创建供应商
                SupplierEntity supplierEntity = new SupplierEntity();
                supplierEntity.setId(IdWorker.getId());
                supplierEntity.setCode("SP-"+supplierEntity.getId());
                supplierEntity.setTenantId(vo.getTenantId());
                supplierEntity.setName(vo.getName());
                iSupplierService.saveOrUpdate(supplierEntity,false);
        	}
        }
    }

    @Override
    public void rollBackByParams(EnterpriseInitVO vo) {
        Long tenantId = vo.getTenantId();
		if(tenantId  == null){
            throw new BusinessException("租户id不存在!");
        }
        if(vo.getInitData()!=null){
            Map<String,Object> map = new HashMap<>();
            if(vo.getInitData().contains("all")){
                map.put("material", "material");
                map.put("def", "def");
            }else{
            	if(vo.getInitData().contains("material")){
                    map.put("material", "material");
            	}
            	if(vo.getInitData().contains("material")){
                    map.put("def", "def");
            	}
            }
        	if(map!=null&&map.size()>0){
        		initMapper.dropThreeTables(tenantId);
        	}
    		QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        	if(vo.getInitData().contains("customer")||vo.getInitData().contains("all")){
                List<CustomerCategoryEntity> customerCategoryEntities = iCustomerCategoryService.queryList(queryParam,false);
                if(ListUtil.isNotEmpty(customerCategoryEntities)){
                    iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(CustomerCategoryEntity::getId).collect(Collectors.toList()));
                }
                List<CustomerEntity> customerEntities = iCustomerService.queryList(queryParam,false);
                if(ListUtil.isNotEmpty(customerEntities)){
                    iCustomerService.removeByIds(customerEntities.stream().map(CustomerEntity::getId).collect(Collectors.toList()));
                }
        	}
        	if(vo.getInitData().contains("supplier")||vo.getInitData().contains("all")){
                List<SupplierEntity> supplierEntityList = iSupplierService.queryList(queryParam,false);
                if(ListUtil.isNotEmpty(supplierEntityList)){
                    iSupplierService.removeByIds(supplierEntityList.stream().map(SupplierEntity::getId).collect(Collectors.toList()));
                }
        	}
        }
    }
}
