package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 设备controller
 * 
 * @author guominga
 *
 */
@RestController
@RequestMapping("/equipment/")
public class EquipmentController implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String EQUIPMENT_BILL_CODE = "SUPPORT_EQUIPMENT";
	
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private IEquipmentService equipmentService;
	@Autowired
	private IEquipmentCategoryService equipmentCategoryService;
	@Autowired
	private IBillCodeGenerator generator;
	@Autowired
	private IBillTypeService billTypeService;
	/**
	 * 新增或者修改
	 * 
	 * @param EquipmentVO
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody EquipmentVO equipmentVo) throws BillCodeException {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(equipmentVo.getId() != null && equipmentVo.getId() > 0) {
			EquipmentVO equipmentBean = equipmentService.queryExitFlag(equipmentVo.getName(),equipmentVo.getSpec(),equipmentVo.getUnitName(),equipmentVo.getCategoryId());
			if(equipmentBean != null && !equipmentBean.getId().equals(equipmentVo.getId())) {
				return CommonResponse.error("该分类下已经有相同名称、单位、规格型号的设备，不允许修改！");
			}
			EquipmentVO uniqueBean = equipmentService.queryDetail(equipmentVo.getId());
			uniqueBean.setCode(equipmentVo.getCode());
			uniqueBean.setName(equipmentVo.getName());
			uniqueBean.setSpec(equipmentVo.getSpec());
			uniqueBean.setUnitName(equipmentVo.getUnitName());
			uniqueBean.setDescription(equipmentVo.getDescription());
			uniqueBean.setSequence(equipmentVo.getSequence());
			
			uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
			uniqueBean.setUpdateTime(new Date());
			uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
			
			equipmentService.update(uniqueBean);
			
			return CommonResponse.success("修改成功");
		} else {
			EquipmentVO equipmentBean = equipmentService.queryExitFlag(equipmentVo.getName(),equipmentVo.getSpec(),equipmentVo.getUnitName(),equipmentVo.getCategoryId());
			if(equipmentBean != null) {
				return CommonResponse.error("该分类下已经有相同名称、单位、规格型号的设备，不允许新增！");
			}
			
			String billCode = generator.generateBillCodeById(EQUIPMENT_BILL_CODE, tenantId);
			equipmentVo.setId(IdWorker.getId());
			equipmentVo.setCode(billCode);
			equipmentVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
			equipmentVo.setCreateTime(new Date());
			equipmentVo.setTenantId(InvocationInfoProxy.getTenantid());
			equipmentVo.setEnabled(1);
			equipmentService.save(equipmentVo);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询设备详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<EquipmentVO> queryDetail(@RequestParam Long id) {
		EquipmentVO equipmentVo = equipmentService.queryDetail(id);
		return CommonResponse.success(equipmentVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			for (Long id : ids) {
				CommonResponse<String>  response = billTypeService.checkQuote("BT200422000000026",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		equipmentService.delete(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		IPage<EquipmentEntity> pageData = equipmentService.queryPage(queryParam);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
		
	}
	
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "equipment-import.xlsx", "设备导入模板");
	}
	
	/**
	 * excel导入
	 * 废弃2020-6-30
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {
				for(int i=0;i<result.size();i++) {
					List<String> datas = result.get(i);
					EquipmentVO equipmentVo = null;
					//通过设备分类Code获取设备分类ID
					List<EquipmentCategoryEntity> equipmentCategoryVo = equipmentCategoryService.queryByCode(String.valueOf(datas.get(0)));
					if(ListUtil.isNotEmpty(equipmentCategoryVo)) {
						equipmentVo = new EquipmentVO();
						equipmentVo.setId(IdWorker.getId());
						equipmentVo.setCategoryId(equipmentCategoryVo.get(0).getId());
						
						if(StringUtils.isBlank(datas.get(1))) {
							try {
								String billCode = generator.generateBillCodeById(EQUIPMENT_BILL_CODE, tenantId);
								equipmentVo.setCode(billCode);
							} catch (BillCodeException e) {
								equipmentVo.setCode(new Date().getTime() + "");
							}
						}else{
							equipmentVo.setCode(datas.get(1));
						}
						equipmentVo.setName(datas.get(2));
						equipmentVo.setSpec(datas.get(3));
						equipmentVo.setUnitName(datas.get(4));
						EquipmentVO equipmentBean = equipmentService.queryExitFlag(equipmentVo.getName(),equipmentVo.getSpec(),equipmentVo.getUnitName(),equipmentCategoryVo.get(0).getId());
						if(equipmentBean != null) {
							continue;
						}
						equipmentVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
						equipmentVo.setCreateTime(new Date());
						equipmentVo.setTenantId(InvocationInfoProxy.getTenantid());
						equipmentVo.setEnabled(1);
						equipmentService.save(equipmentVo);
					}else{
						errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：设备分类编号不正确！");
						continue;
					}
				}
			}
			if(errorList.size() > 0) {
				errorList.add("导入成功："+(result.size() - errorList.size() - 1)+"条, 失败：" +errorList.size()+"条");
				
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}


	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/29 设备详情导入excel校验
	 * @Description excelMaterialImport
	 * @Param [request, response]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
	 */
	@RequestMapping(value = "/excelEquipmentImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> excelEquipmentImport(HttpServletRequest request ) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		boolean isFailed = false;
		MultipartFile mf = null;
		List<MaterialImportVO> successList = new ArrayList<>();
		List<MaterialImportVO> errorList = new ArrayList<>();
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				if(result.size()>10000){
					return CommonResponse.error("设备数据超过10000条，请分批上传！");
				}
				Map<String,List<EquipmentCategoryEntity>> caListMap = new HashMap<>();
				Map<String,EquipmentVO> entityMap = new HashMap<>();
				Map<String,MaterialImportVO> materialBeanMap = new HashMap<>();
				for(int i = 0;i < result.size(); i++) {
					List<String> datas = result.get(i);
					MaterialImportVO materialVo = new MaterialImportVO();
					materialVo.setId(IdWorker.getId());
					materialVo.setCategoryCode(datas.get(0));
					materialVo.setCode(datas.get(1));
					materialVo.setName(datas.get(2));
					materialVo.setSpec(datas.get(3));
					materialVo.setUnitName(datas.get(4));
					if(StringUtils.isBlank(datas.get(0))){
						materialVo.setDescription("设备分类编号为空！");
						errorList.add(materialVo);
						continue;
					}
					//通过设备分类Code获取设备分类ID
					List<EquipmentCategoryEntity> materialCategoryVo = caListMap.get(datas.get(0));
					if(ListUtil.isEmpty(materialCategoryVo)){
						materialCategoryVo = equipmentCategoryService.queryByCode(String.valueOf(datas.get(0)));
						if(ListUtil.isNotEmpty(materialCategoryVo)){
							caListMap.put(datas.get(0),materialCategoryVo);
						}
					}
					if(ListUtil.isNotEmpty(materialCategoryVo)) {
						materialVo.setCategoryId(materialCategoryVo.get(0).getId());
						try {
							if(StringUtils.isBlank(datas.get(1))){
								String billCode = generator.generateBillCodeById(EQUIPMENT_BILL_CODE, tenantId);
								materialVo.setCode(billCode);
							}else {//有编号，判重
								EquipmentVO vo = entityMap.get(datas.get(1));
								if(vo == null){
									vo = equipmentService.queryByCode(datas.get(1));
									if(vo!=null){
										entityMap.put(datas.get(1),vo);
									}
								}
								if(vo!=null){
									materialVo.setDescription("设备编号重复！");
									errorList.add(materialVo);
									continue;
								}
							}
						} catch (BillCodeException e) {
							materialVo.setCode(new Date().getTime() + "");
						}

						MaterialImportVO materialBean = materialBeanMap.get(materialVo.getName()+materialVo.getSpec()+materialVo.getUnitName()+materialCategoryVo.get(0).getId());
						if(materialBean == null){
							materialBeanMap.put(materialVo.getName()+materialVo.getSpec()+materialVo.getUnitName()+materialCategoryVo.get(0).getId(),materialBean);
							EquipmentVO equipmentBeanVo = equipmentService.queryExitFlag(materialVo.getName(),materialVo.getSpec(),materialVo.getUnitName(),materialCategoryVo.get(0).getId());
							if(equipmentBeanVo != null) {
								materialBean = materialVo;
								materialBeanMap.remove(materialVo.getName()+materialVo.getSpec()+materialVo.getUnitName()+materialCategoryVo.get(0).getId());
							}
						}
						if(materialBean != null) {
							materialVo.setDescription("重复设备！");
							errorList.add(materialVo);
							continue;
						}
						materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
						materialVo.setCreateTime(new Date());
						materialVo.setTenantId(InvocationInfoProxy.getTenantid());
						materialVo.setEnabled(1);
						successList.add(materialVo);
					}else{
						materialVo.setDescription("设备分类编号不存在！");
						errorList.add(materialVo);
					}
				}
				entityMap.clear();
				materialBeanMap.clear();
			}
		}
		JSONObject json = new JSONObject();
		json.put("successList", successList);
		json.put("errorList", errorList);
		return CommonResponse.success(json);
	}

	@RequestMapping(value = "/saveImportExcelEquipment", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveImportExcelEquipment(@RequestBody List<MaterialImportVO> importVOS){
		if(ListUtil.isEmpty(importVOS)){
			return CommonResponse.error("导入的数据为空！");
		}
		List<EquipmentVO> list = new ArrayList<>();
		importVOS.forEach(importVO->list.add(BeanMapper.map(importVO,EquipmentVO.class)));
		equipmentService.insertBatch(list);
		return CommonResponse.success("保存成功！");
	}
	
	/**
	 * excel导出
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		List<EquipmentEntity> resultList = equipmentService.queryList(queryParam);
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", resultList);
		ExcelExport.getInstance().export("equipment-export.xlsx", beans, response);
	}
	
	/**
	 * 同步平台设备
	 * 
	 * @return
	 */
	@RequestMapping(value = "/sync", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncEquipmentList() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(OMS_TENANT.equals(tenantId.toString())) {
			return CommonResponse.error("平台运营人员不能操作此功能");
		}
		equipmentService.insertEquipmentListFromPlatform();
		return CommonResponse.success("同步成功");
	}
	
	

	/**
	 * 设备列表
	 * 
	 * @param pageNumber
	 * @param pageSize
	 * @param relyCondition
	 * @param searchText
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "refEquipmentPage", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<EquipmentEntity>> refEquipmentPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
												   @RequestParam(required=false) String relyCondition,
												   @RequestParam(required=false) String searchText,
												   @RequestParam(required=false) String condition
								) {
		Map<String,Object> params = new HashMap<>();
    	if(StringUtils.isNotBlank(relyCondition)){
    		if(StringUtils.isBlank(searchText)){
	    		Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
	    		EquipmentCategoryVO equipmentCategoryVo = equipmentCategoryService.queryDetail(categoryId);
	    		if(equipmentCategoryVo != null) {
	    			params.put("innerCode", equipmentCategoryVo.getInnerCode());
	    		}
    		}
    	}
    	params.put("pageIndex", pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
    	params.put("pageSize", pageSize);
    	params.put("searchText", searchText);
    	params.put("tenantId", InvocationInfoProxy.getTenantid());
    	IPage<EquipmentEntity> pageData = equipmentService.queryRefEquipmentPage(params);
		pageData.setCurrent(pageNumber);
		pageData.setSize(pageSize);
        return CommonResponse.success("查询成功！", pageData);
	}

}
