package com.ejianc.foundation.share.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;

@Mapper
public interface EquipmentCategoryMapper {

	List<EquipmentCategoryEntity> queryList(Map<String, Object> condition);

	EquipmentCategoryEntity queryDetail(@Param("tenantId") Long tenantId,@Param("id") Long id);

	void update(EquipmentCategoryEntity entity);

	void insert(EquipmentCategoryEntity entity);

	void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<EquipmentCategoryEntity> list);

	List<EquipmentCategoryEntity> queryListByPid(@Param("tenantId") Long tenantId, @Param("id") Long id);

	void delete(@Param("tenantId") Long tenantId,@Param("id") Long id);

	void updateEnabled(@Param("enabled") Integer enabled,@Param("tenantId") Long tenantId,@Param("innerCode") String innerCode);

	List<EquipmentCategoryEntity> queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

	List<EquipmentCategoryEntity> queryByName(@Param("tenantId") Long tenantId, @Param("name") String name);

	void insertCategoryListFromPlatform(@Param("tenantId") Long tenantId);

	List<EquipmentCategoryEntity> queryListTree(Map<String, Object> params);

}
