package com.ejianc.foundation.supplier.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 正元供应商年度评价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zy_supplier_year")
public class SupplierYearEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 考核内容
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="supply_id")
    private Long supplyId; // 供应商id
    @TableField(value="supply_name")
    private String supplyName; // 供应商名称
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 累计金额
    @TableField(value="primary_grade")
    private String primaryGrade; // 原登记
    @TableField(value="end_date")
    private java.util.Date endDate; // 截止时间
    @TableField(value="total_num")
    private Integer totalNum; // 累计合作次数
    @TableField(value="process_branch")
    private BigDecimal processBranch; // 过程扣分
    @TableField(value="incident_branch")
    private BigDecimal incidentBranch; // 事件扣分
    @TableField(value="punish_type")
    private Long punishType; // 处置方式
    @TableField(value="punish_type_name")
    private String punishTypeName; // 处置方式名称
    @TableField(value="handle_date")
    private java.util.Date handleDate; // 办理时间
    @TableField(value="process_id")
    private Long processId; // 经办人id
    @TableField(value="process")
    private String process; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="status")
    private Integer status; // 状态:0---未评价----1已评价
    @TableField(value="supply_type")
    private String supplyType; // 供应商类别
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供应商类别名称
    @TableField(value="thi_year_num")
    private Integer thiYearNum; // 本年合同数
    @TableField(value="cooperation_project_id")
    private Long cooperationProjectId; // 合作项目id
    @TableField(value="cooperation_project_name")
    private String cooperationProjectName; // 合作项目
    @TableField(value="cooperation_org_id")
    private Long cooperationOrgId; // 合作单位id
    @TableField(value="cooperation_org_name")
    private String cooperationOrgName; // 合作单位名字
    @TableField(value="year_deduct")
    private Integer yearDeduct; // 年度扣分
    @TableField(value="create_user_id")
    private Long createUserId;
    @TableField(value="create_user_name")
    private String createUserName;
    @TableField(value="phone")
    private String phone;
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub

    @TableField(exist=false)
    @SubEntity(serviceName="yearContentService")
    private List<SupplierYearContentEntity> yearContentEntities = new ArrayList<>(); // 年度评价内容

    @TableField(value="head_user_name")
    private String headUserName;//分包负责人
    @TableField(value="head_user_id")
    private Long headUserId;//分包负责人id

    // 计算开始时间
    @TableField(value="old_start_date")
    private String oldStartDate;
    @TableField(value="org_id")
    private Long orgId; // 项目id
    @TableField(value="org_name")
    private String orgName; // 项目名称
    @TableField(value="org_code")
    private String orgCode; // 项目编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="evaluation_obj_state")
    private Integer evaluationObjState; // 评价对象（只有评价类型是劳务分包合同时该字段才会赋值）：1、劳务供应商；2、分包负责人；
    @TableField(value="evaluation_obj_name")
    private String  evaluationObjName; // 评价对象名称
    @TableField(value="total_branch")
    private BigDecimal totalBranch; //调整后得分
    @TableField(value="grade")
    private Long grade; // 调整后等级评定
    @TableField(value="grade_name")
    private String gradeName; // 调整后评价名称

    public Integer getEvaluationObjState() {
        return evaluationObjState;
    }

    public void setEvaluationObjState(Integer evaluationObjState) {
        this.evaluationObjState = evaluationObjState;
    }

    public String getEvaluationObjName() {
        return evaluationObjName;
    }

    public void setEvaluationObjName(String evaluationObjName) {
        this.evaluationObjName = evaluationObjName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getOldStartDate() {
        return oldStartDate;
    }

    public void setOldStartDate(String oldStartDate) {
        this.oldStartDate = oldStartDate;
    }
    /**
     * 考核内容
     */
    public String getName() {
        return name;
    }

    /**
     * 考核内容
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 供应商id
     */
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商id
     */
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 累计金额
     */
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * 累计金额
     */
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    /**
     * 原登记
     */
    public String getPrimaryGrade() {
        return primaryGrade;
    }

    /**
     * 原登记
     */
    public void setPrimaryGrade(String primaryGrade) {
        this.primaryGrade = primaryGrade;
    }
    /**
     * 截止时间
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 截止时间
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 累计合作次数
     */
    public Integer getTotalNum() {
        return totalNum;
    }

    /**
     * 累计合作次数
     */
    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }
    /**
     * 过程扣分
     */
    public BigDecimal getProcessBranch() {
        return processBranch;
    }

    /**
     * 过程扣分
     */
    public void setProcessBranch(BigDecimal processBranch) {
        this.processBranch = processBranch;
    }
    /**
     * 事件扣分
     */
    public BigDecimal getIncidentBranch() {
        return incidentBranch;
    }

    /**
     * 事件扣分
     */
    public void setIncidentBranch(BigDecimal incidentBranch) {
        this.incidentBranch = incidentBranch;
    }
    /**
     * 
     */
    public BigDecimal getTotalBranch() {
        return totalBranch;
    }

    /**
     * 
     */
    public void setTotalBranch(BigDecimal totalBranch) {
        this.totalBranch = totalBranch;
    }
    /**
     * 等级评定
     */
    public Long getGrade() {
        return grade;
    }

    /**
     * 等级评定
     */
    public void setGrade(Long grade) {
        this.grade = grade;
    }
    /**
     * 评价名称
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 评价名称
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 处置方式
     */
    public Long getPunishType() {
        return punishType;
    }

    /**
     * 处置方式
     */
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    /**
     * 处置方式名称
     */
    public String getPunishTypeName() {
        return punishTypeName;
    }

    /**
     * 处置方式名称
     */
    public void setPunishTypeName(String punishTypeName) {
        this.punishTypeName = punishTypeName;
    }
    /**
     * 办理时间
     */
    public java.util.Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理时间
     */
    public void setHandleDate(java.util.Date handleDate) {
        this.handleDate = handleDate;
    }
    /**
     * 经办人id
     */
    public Long getProcessId() {
        return processId;
    }

    /**
     * 经办人id
     */
    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    /**
     * 经办人
     */
    public String getProcess() {
        return process;
    }

    /**
     * 经办人
     */
    public void setProcess(String process) {
        this.process = process;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 年度评价内容
     */
    public List<SupplierYearContentEntity> getYearContentEntities() {
        return yearContentEntities;
    }

    /**
     * 年度评价内容
     */
    public void setYearContentEntities(List<SupplierYearContentEntity> yearContentEntities) {
        this.yearContentEntities = yearContentEntities;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public Integer getThiYearNum() {
        return thiYearNum;
    }

    public void setThiYearNum(Integer thiYearNum) {
        this.thiYearNum = thiYearNum;
    }

    public Long getCooperationProjectId() {
        return cooperationProjectId;
    }

    public void setCooperationProjectId(Long cooperationProjectId) {
        this.cooperationProjectId = cooperationProjectId;
    }

    public String getCooperationProjectName() {
        return cooperationProjectName;
    }

    public void setCooperationProjectName(String cooperationProjectName) {
        this.cooperationProjectName = cooperationProjectName;
    }

    public Long getCooperationOrgId() {
        return cooperationOrgId;
    }

    public void setCooperationOrgId(Long cooperationOrgId) {
        this.cooperationOrgId = cooperationOrgId;
    }

    public String getCooperationOrgName() {
        return cooperationOrgName;
    }

    public void setCooperationOrgName(String cooperationOrgName) {
        this.cooperationOrgName = cooperationOrgName;
    }

    public Integer getYearDeduct() {
        return yearDeduct;
    }

    public void setYearDeduct(Integer yearDeduct) {
        this.yearDeduct = yearDeduct;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public Long getHeadUserId() {
        return headUserId;
    }

    public void setHeadUserId(Long headUserId) {
        this.headUserId = headUserId;
    }
}
