package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.bean.SupplierPunishEntity;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.service.ISupplierPunishService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplier")
public class SupplierController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierPunishService punishService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISupplierGradeService gradeService;

    private static final String BILL_CODE = "ZY_SUPPLIER_CODE";//此处需要根据实际修改

    @Autowired
    private ISupplierService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO saveOrUpdateVO) {
    	SupplierEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            if(!(Objects.equals(InvocationInfoProxy.getOrgType(),"1") || Objects.equals(InvocationInfoProxy.getOrgType(),"2"))){
                return CommonResponse.error("请切换组织到集团或者二级单位后再次操作！");
            }
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setGroupBlack(false);
            entity.setBlackOrgIds("");
            entity.setBlackOrgNames("");
            QueryParam queryParam = QueryParam.getInstance();
            queryParam.getParams().put("name", new Parameter(QueryParam.EQ, saveOrUpdateVO.getGradeName()));
            List<SupplierGradeEntity> gradeEntities = gradeService.queryList(queryParam,false);
            if(ListUtil.isEmpty(gradeEntities)){
                return CommonResponse.error("保存供应商失败！没有找到【"+saveOrUpdateVO.getGradeName()+"级】供应商等级设置！");
            }
            entity.setYearScore(gradeEntities.get(0).getReachScore().add(new BigDecimal("1")));
        }
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("taxNum", new Parameter(QueryParam.EQ, saveOrUpdateVO.getTaxNum()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        List<SupplierEntity> supplierEntities = service.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(supplierEntities)){
            SupplierEntity supplierEntity = supplierEntities.get(0);
            if("p".equals(supplierEntity.getPersonal())){
                return CommonResponse.error("身份证号为【"+saveOrUpdateVO.getTaxNum()+"】的供应商已被组织【"+supplierEntity.getOrgName()+"】录入了，请重新输入！");
            }
            return CommonResponse.error("纳税人识别号为【"+saveOrUpdateVO.getTaxNum()+"】的供应商已被组织【"+supplierEntity.getOrgName()+"】录入了，请重新输入！");
        }
    	service.saveOrUpdate(entity, false);
    	SupplierVO vo = BeanMapper.map(entity, SupplierVO.class);
    	return CommonResponse.success("保存或修改供应商成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(Long id) {
    	SupplierEntity entity = service.selectById(id);
    	SupplierVO vo = BeanMapper.map(entity, SupplierVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SupplierVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SupplierVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("taxNum");
        fuzzyFields.add("productionTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SupplierEntity> page = service.queryPage(param,false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SupplierEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Supplier-export.xlsx", beans, response);
    }

    /**
     * @Description 正常供应商参照
     * @Return void
     */
    @RequestMapping(value = "/refSupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("groupBlack", new Parameter(QueryParam.EQ, false));
        param.getParams().put("blackOrgIds", new Parameter(QueryParam.NOT_LIKE, InvocationInfoProxy.getOrgId()+""));

        IPage<SupplierEntity> page = service.queryPage(param,false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 异常 供应商参照
     * @Return void
     */
    @RequestMapping(value = "/refExceptionSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refExceptionSupplier(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        if(Objects.equals(InvocationInfoProxy.getOrgType(),"1")){
            /** 集团黑名单 */
            param.getParams().put("groupBlack", new Parameter(QueryParam.EQ, true));
        }else {
            /** 组织黑名单*/
            param.getParams().put("blackOrgIds", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getOrgId()+""));
        }

        IPage<SupplierEntity> page = service.queryPage(param,false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SupplierVO> records = BeanMapper.mapList(page.getRecords(), SupplierVO.class);
        if(!Objects.equals(InvocationInfoProxy.getOrgType(),"1")){
            /** 组织黑名单 将其处置单结束时间同步到 groupLastTime */
            records.forEach(supplier->{
                QueryParam queryParam = QueryParam.getInstance();
                queryParam.getParams().put("supplyId", new Parameter(QueryParam.EQ,supplier.getId()));
                queryParam.getParams().put("applyOrgId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
                queryParam.getParams().put("pushState", new Parameter(QueryParam.EQ,"2"));
                List<SupplierPunishEntity> punishList = punishService.queryList(queryParam, false);
                if(ListUtil.isNotEmpty(punishList)){
                    supplier.setGroupLastTime(punishList.get(0).getPunishLastTime());
                }
            });
        }
        pageData.setRecords(records);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/updateAllSupplierGrade", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateAllSupplierGrade() {
        String msg = service.updateAllSupplierGrade(null);
        if(StringUtils.isNotEmpty(msg)){
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("更新供应商等级成功！");
    }
    @RequestMapping(value = "/querySupplierByNameOrSocialCreditCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querySupplierByNameOrSocialCreditCode(String supplierName, String socialCreditCode) {
        return CommonResponse.success("查询成功！", service.querySupplierByNameOrSocialCreditCode(supplierName, socialCreditCode));
    }
}
