package com.ejianc.foundation.supplier.mapper;

import com.ejianc.foundation.supplier.bean.SupplerIncidentEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
@Mapper
public interface SupplerIncidentMapper extends BaseCrudMapper<SupplerIncidentEntity> {
    @Select("SELECT DISTINCT i.org_id FROM ejc_zy_supplier_incident i WHERE i.dr = 0 AND YEAR(i.create_time) = #{year} AND i.bill_state IN (1,3) AND i.status = 1 AND i.dr = 0 ")
    List<Long> getYearOrgIds(@Param("year") int year);

    /**
     * 获取供应商 过程评价列表
     * 使用billState 作为与该供应商的合作次数
     * @param orgId
     * @param year
     * @return
     */
    @Select("SELECT  i.supply_id ,i.supply_name ,i.org_id ,i.org_name ,i.org_code,SUM(i.contract_amount) contract_amount, AVG(i.buckle_branch) buckle_branch,COUNT(1) bill_state " +
            " FROM ejc_zy_supplier_incident i WHERE i.dr = 0 AND i.org_id = #{orgId} AND YEAR(i.create_time) = #{year} AND i.bill_state IN (1,3) AND i.status = 1 GROUP BY i.supply_id ")
    List<SupplerIncidentEntity> getIncidentList(@Param("orgId") Long orgId, @Param("year") int year);
}
