package com.ejianc.foundation.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.supplier.bean.SupplierComModleContentEntity;
import com.ejianc.foundation.supplier.bean.SupplierCommentModleEntity;
import com.ejianc.foundation.supplier.mapper.SupplierCommentModleMapper;
import com.ejianc.foundation.supplier.service.ISupplierComModleContentService;
import com.ejianc.foundation.supplier.service.ISupplierCommentModleService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商评价模板
 * 
 * @author generator
 * 
 */
@Service("supplierCommentModleService")
public class SupplierCommentModleServiceImpl extends BaseServiceImpl<SupplierCommentModleMapper, SupplierCommentModleEntity> implements ISupplierCommentModleService{

    @Autowired
    private ISupplierComModleContentService supplierComModleContentService;

    /**
     * @param supplyTypeName
     * @param commentType
     * @return
     */
    @Override
    public SupplierCommentModleEntity queryTypeName(String supplyTypeName, String commentType) {
        QueryWrapper<SupplierCommentModleEntity> queryWrapper = new QueryWrapper<>();
        if(StringUtils.isNotEmpty(commentType)){
            queryWrapper.eq("comment_type", commentType);
        }
        queryWrapper.eq("state",true);

        List<SupplierCommentModleEntity> list =this.list(queryWrapper);
        if(CollectionUtil.isNotEmpty(list)){
            SupplierCommentModleEntity entity =list.get(0);
            return entity;
        }
        return null;
    }

    /**
     * 修改状态
     *
     * @param id
     * @param state
     */
    @Override
    public void updateState(Long id, Boolean state) {
        SupplierCommentModleEntity entity =this.getById(id);
        entity.setState(state);
        this.saveOrUpdate(entity, false);
    }

    /**
     * @param entity
     */
    @Override
    public void checkModleName(SupplierCommentModleEntity entity) {
        QueryParam param = new QueryParam();
        param.getParams().put("name",new Parameter(QueryParam.EQ,entity.getName()));
        List<SupplierCommentModleEntity> list =this.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            throw new BusinessException("模板名称已经存在！");
        }
    }

    /**
     * @param entity
     */
    @Override
    public void saveOrChild(SupplierCommentModleEntity entity) {
        List<SupplierComModleContentEntity> listbs = entity.getSupplierComModleContentList();
        Map<Long,Long> idMap=new HashMap<>();
        for(SupplierComModleContentEntity cdEntity:listbs){
            idMap.put(cdEntity.getTid(),cdEntity.getId());
        }
        for(SupplierComModleContentEntity cdEntity:listbs){
            if(999L!=cdEntity.getParentId()){
                cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                cdEntity.setTid(cdEntity.getId());
                if(org.apache.commons.lang3.StringUtils.isEmpty(cdEntity.getItem())){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"扣分事项不能为空!");
                }
                if(cdEntity.getDeduct() == null){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"扣分值不能为空!");
                }
            }else{
                if(org.apache.commons.lang3.StringUtils.isEmpty(cdEntity.getName())){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"考核内容不能为空!");
                }
                cdEntity.setTid(cdEntity.getId());
            }
        }
        supplierComModleContentService.saveOrUpdateBatch(listbs,listbs.size(),false);
    }

    /**
     * @param entity
     */
    @Override
    public void saveOrUpdates(SupplierCommentModleEntity entity) {
        this.saveOrUpdate(entity,false);
        checkModleName(entity);
        saveOrChild(entity);
    }
}
