package com.ejianc.foundation.supplier.service.impl;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierPunishEntity;
import com.ejianc.foundation.supplier.service.ISupplierPunishService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("supplierPunish") 
public class SupplierPunishBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private ISupplierPunishService service;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IOrgApi iOrgApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplierPunishEntity entity = service.selectById(billId);
		if(entity==null){
			return CommonResponse.error("处置单不存在！");
		}
		CommonResponse<OrgVO> org = iOrgApi.getOneById(entity.getApplyOrgId());
		if(!org.isSuccess()){
			return CommonResponse.error("获取组织信息失败！");
		}
		SupplierEntity supplier = supplierService.selectById(entity.getSupplyId());
		if(supplier==null){
			return CommonResponse.error("被处置的供应商不存在！");
		}
		if(org.getData().getOrgType()==1){
			/** 集团 直接更细到供应商信息中 全部拉黑 */
			supplier.setGroupBlack(true);
			supplier.setGroupLastTime(entity.getPunishLastTime());
			supplierService.saveOrUpdate(supplier, false);
		}else {
			/** 其他组织 ， 直接更新到供应商拉黑单位*/
			if(StringUtils.isEmpty(supplier.getBlackOrgIds())){
				supplier.setBlackOrgIds(entity.getApplyOrgId().toString());
				supplier.setBlackOrgNames(entity.getApplyOrg());
			}else {
				supplier.setBlackOrgIds(supplier.getBlackOrgIds()+","+entity.getApplyOrgId());
				supplier.setBlackOrgNames(supplier.getBlackOrgNames()+","+entity.getApplyOrg());
			}
			supplierService.saveOrUpdate(supplier, false);
		}
		entity.setPushState("2");//已生效
		service.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
