package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.vo.PublishVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.ParamRegisterEntity;
import com.ejianc.foundation.support.service.IParamRegisterService;
import com.ejianc.foundation.support.vo.ParamRegisterVO;

/**
 * 参数注册
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("paramRegister")
public class ParamRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private IParamRegisterService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamRegisterVO> saveOrUpdate(@RequestBody ParamRegisterVO saveorUpdateVO) throws BillCodeException {
    	ParamRegisterEntity entity = BeanMapper.map(saveorUpdateVO, ParamRegisterEntity.class);
    	if(InvocationInfoProxy.getTenantid() != 999999){
    	    return CommonResponse.error("非法租户，无法创建参数");
        }
    	if(!(entity.getId()!=null && entity.getId() != 0L)){
            String billCode = generator.generateBillCodeById("param-register-001", InvocationInfoProxy.getTenantid());
            entity.setCode(billCode);
        }
        entity.setTenantId(999999L);
    	service.saveOrUpdate(entity, false);
    	ParamRegisterVO vo = BeanMapper.map(entity, ParamRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamRegisterVO> queryDetail(Long id) {
    	ParamRegisterEntity entity = service.selectById(id);
    	ParamRegisterVO vo = BeanMapper.map(entity, ParamRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description 配置 租户 参数
     * 根据注册参数的id配置当前登录租户的参数
     * @param id
     */
    @RequestMapping(value = "/configTenantParam", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> configTenantParam(Long id) {
        return service.configTenantParam(id);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ParamRegisterVO> vos) {
        service.removeByIds(vos.stream().map(ParamRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ParamRegisterVO>> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, 999999));

        IPage<ParamRegisterEntity> page = service.queryPage(param,false);
        IPage<ParamRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ParamRegisterVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/1/15 发布参数
     * @Description publishParamConfig
     * @Param [publishVO]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @RequestMapping(value = "/publishParamConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO){
        return service.publishParamConfig(publishVO);
    }

}
