package com.ejianc.foundation.support.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IBillTypeService extends IBaseService<BillTypeEntity> {

	/**
	 * 删除
	 * 
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询详情
	 * 
	 * @param id
	 * @return
	 */
	BillTypeVO queryDetail(Long id);

	/**
	 * 查询单据类型树
	 *
	 * @return
	 */
	List<Map<String, Object>> getBillTypeTree();
	List<Map<String, Object>> getBillTypeTreeByCodes(String codes);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/7/14 单据编码引用校验
	 * @Description checkQuote
	 * @Param [billTypeCode, billId]
	 * @Return void
	 */
	CommonResponse<String> checkQuote(String billTypeCode, Long billId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/7/14 单据编码引用校验
	 * @Description checkQuote
	 * @Param [billTypeCode, billIds]
	 * @Return void
	 */
	CommonResponse<Map<String, String>> checkQuotes(String billTypeCode, List<Long> billIds);

	/**
	 * 根据元数据Id查询对应的单据类型
	 *
	 * @param metadataId 元数据Id
	 * @return
	 */
    BillTypeVO getByMetadataId(Long metadataId);

    /**
     * 查询所有单据类型
     * 
     * @return
     */
	List<BillTypeEntity> queryAllBillTypeList();

	/**
	 * @description:  根据单据编码引用检查
	 *
	 * @param billTypeCode
	 * @param billIds
	 * @return {@link CommonResponse< List< Long>>} 返回引用的单据ids
	 * @author songlx
	 * @date: 2024/5/15
	 */
	CommonResponse<List<Long>> checkQuotesAndReturnQuoteBillIds(String billTypeCode, List<Long> billIds);
}
