package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.entity.BillCodeSNEntity;
import com.ejianc.foundation.billcode.service.IBcrSnService;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.mapper.BillCodeRuleMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("billTypeRuleService")
public class BillCodeRuleServiceImpl extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity> implements IBillCodeRuleService {

    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;

    @Value("${oms.tenantid}")
    private String BASE_TNANT_ID;

    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillCodeEngineService billCodeEngineService;
    @Autowired
    private IBcrSnService bcrSnService;

    @Override
    public void delete(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public BillCodeRuleVO queryDetail(Long id) {
    	Long tenantId = InvocationInfoProxy.getTenantid();
        BillCodeRuleVO vo = null;
        BillCodeRuleEntity entity = baseMapper.selectById(id);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    private void queryAttrDetail(BillCodeRuleVO vo, Long tenantId) {
        //先查询本租户下的编码规则属性
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.EQ, vo.getId()));
        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        q.getOrderMap().put("elem_order", QueryParam.ASC);
        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
        if(CollectionUtils.isEmpty(attrs)) {
            //若本租户下的编码规则属性为空，则查询公共编码规则属性
            q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, BASE_TNANT_ID));
            attrs = billCodeRuleAttrService.getListByProperties(q, false);
        }
        vo.setAttrs(attrs);
    }
    
    private void queryAttrDetail(BillCodeRuleVO vo, BillCodeParam billCodeParam) {
        //先查询本租户下的编码规则属性
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.EQ, vo.getId()));
        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, billCodeParam.getTenantId()));
        q.getOrderMap().put("elem_order", QueryParam.ASC);
        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
        if(CollectionUtils.isEmpty(attrs)) {
            //若本租户下的编码规则属性为空，则查询公共编码规则属性
            q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, BASE_TNANT_ID));
            attrs = billCodeRuleAttrService.getListByProperties(q, false);
        }
        if(attrs != null && attrs.size() > 0) {
        	JSONObject billDetail = billCodeParam.getBillDetail();
        	if(billDetail != null) {
        		for(BillCodeRuleAttrVO billCodeRuleAttrVO:attrs) {
                    if(StringUtils.isNotBlank(billCodeRuleAttrVO.getElemValue())){
                        String key = billCodeRuleAttrVO.getElemValue().trim();
                        String billValue = billDetail.getString(key);
                        if(StringUtils.isNotBlank(billValue)) {
                            billCodeRuleAttrVO.setBillValue(billValue);
                        }
                    }
        		}
        	}
        }
        vo.setAttrs(attrs);
    }

    @Override
    public void save(BillCodeRuleVO billCodeRuleVo) {
        BillCodeRuleEntity saveEntity = null;
        List<BillCodeRuleAttrVO> attrs = new ArrayList<>();
        if(null != billCodeRuleVo.getId()) {
            //更新
            attrs = billCodeRuleVo.getAttrs();

            saveEntity = baseMapper.selectById(billCodeRuleVo.getId());
            saveEntity.setRuleName(billCodeRuleVo.getRuleName());
            super.saveOrUpdate(saveEntity);
        } else {
            //新增
            billCodeRuleVo.setDr(BaseVO.DR_UNDELETE);
            billCodeRuleVo.setTenantId(InvocationInfoProxy.getTenantid());
            saveEntity = BeanMapper.map(billCodeRuleVo, BillCodeRuleEntity.class);
            super.saveOrUpdate(saveEntity);

            attrs = billCodeRuleVo.getAttrs();
        }

        if(CollectionUtils.isNotEmpty(attrs)) {
            //更新对应子元素：全部删除，重新新增
            billCodeRuleAttrService.save(attrs, saveEntity.getId(), true);
        }
    }

    @Override
    public BillCodeRuleVO queryDetail(String ruleCode) {
        BillCodeRuleVO vo = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", ruleCode);
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(null != entity) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

	@Override
	public BillCodeRuleVO queryDetailByCodeAndTenantId(String code, Long tenantId) {
		BillCodeRuleVO vo = null;
		QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", code);
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo,tenantId);
        }
        return vo;
	}

	@Override
	public BillCodeRuleVO queryBillCodeDetail(BillCodeParam billCodeParam) {
		BillCodeRuleVO vo = null;
		QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", billCodeParam.getRuleCode());
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, billCodeParam);
        }
        return vo;
	}


    @Override
    public List<BillCodeSNVO> queryBillCodeSnList(Long id) {
        List<BillCodeSNVO> resp = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("mark_str", new Parameter(QueryParam.EQ, markStr));
//        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<BillCodeSNEntity> eList =  bcrSnService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(eList)) {
            for(BillCodeSNEntity entity : eList){
                BillCodeSNVO vo = BeanMapper.map(entity, BillCodeSNVO.class);
                String range = "";
                try {
                    Long tenantId = vo.getTenantId();
                    if(tenantId!=null){
                        JSONArray jArray = ReferObjectUtil.getReferEntityValue(tenantId.toString(), "idm-tenant");
                        if(jArray!=null&&jArray.size()>0){
                            JSONObject json = (JSONObject) jArray.get(0);
                            range = json.get("name").toString();
                        }
                    }
                    if(StringUtils.isBlank(range)){
                        JSONArray jArray = ReferObjectUtil.getReferEntityValue(tenantId.toString(), "idm-org");
                        if(jArray!=null&&jArray.size()>0){
                            JSONObject json = (JSONObject) jArray.get(0);
                            range = json.get("name").toString();
                        }
                    }
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }

                vo.setRange(range);//获取组织/租户信息
                String markStr = vo.getMarkStr();
                markStr = markStr.replace("^custom^","").replace("^sysentityattr^","").replace("^sysdate^","");
                vo.setFlowBasis(markStr);
                vo.setOldsn(vo.getLastsn());
                resp.add(vo);
            }
        }
        return resp;
    }

    @Override
    public void updateLastsn(BillCodeSNVO vo) {
        String RETURN_BILL_CODE_CACHE_KEY_PREFIX = "returnejcbillcode";
        String BILL_CODE_SN_REFER_CACHE_KEY_PREFIX = "ejcbillcode";
        String CACHE_KEY_SEPERATOR = ":";
        String key = RETURN_BILL_CODE_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
        billCodeEngineService.updateSNVO(vo.getRuleId().toString(), vo.getMarkStr(), vo.getLastsn(), vo.getTenantId());

        List<BillCodeReternVO> rtnvos = new ArrayList<>();
        rtnvos.add(BeanMapper.map(vo, BillCodeReternVO.class));
        cacheManager.set(key, JSONArray.toJSONString(rtnvos));

        String key2 = BILL_CODE_SN_REFER_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
        cacheManager.set(key2, vo);
    }


    @Override
    public void updateLastsnList(List<BillCodeSNVO> vos) {
        for(BillCodeSNVO vo : vos){
            String RETURN_BILL_CODE_CACHE_KEY_PREFIX = "returnejcbillcode";
            String BILL_CODE_SN_REFER_CACHE_KEY_PREFIX = "ejcbillcode";
            String CACHE_KEY_SEPERATOR = ":";
            String key = RETURN_BILL_CODE_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
            billCodeEngineService.updateSNVO(vo.getRuleId().toString(), vo.getMarkStr(), vo.getLastsn(), vo.getTenantId());

            List<BillCodeReternVO> rtnvos = new ArrayList<>();
            rtnvos.add(BeanMapper.map(vo, BillCodeReternVO.class));
            cacheManager.set(key, JSONArray.toJSONString(rtnvos));

            String key2 = BILL_CODE_SN_REFER_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
            cacheManager.set(key2, vo);
        }
    }
}
