package com.ejianc.foundation.support.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.bean.ReferEntity;
import com.ejianc.foundation.support.bean.ReferShowfieldEntity;
import com.ejianc.foundation.support.mapper.ReferMapper;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.service.IReferShowfieldService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

@Service
public class ReferServiceImpl extends BaseServiceImpl<ReferMapper, ReferEntity> implements IReferService {

	@Autowired
	private IReferShowfieldService referShowfieldService;
	@Autowired
	private IModuleService moduleService;
	@Autowired
	private EnvironmentTools environmentTools;

	@Value("${refer.base-host:null}")
	private String baseHost;

	@Override
	@Transactional
	public CommonResponse<String> saveOrUpdate(ReferVO referVo, boolean syncEs) {
		ReferEntity entity = new ReferEntity();
		entity.setDr(0);
		QueryWrapper<ReferEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("ref_code", referVo.getRefCode());
		queryWrapper.eq("dr", 0);
		if (referVo.getId() != null) {
			// 校验编号是否重复
			queryWrapper.ne("id", referVo.getId());
			List<ReferEntity> codeEntity = this.list(queryWrapper);
			if (codeEntity != null && codeEntity.size() > 0) {
				return CommonResponse.error("保存失败，参照编号已存在，请重新填写!!!");
			}
			// 修改
			ReferEntity oldEntity = super.getById(referVo.getId());
			oldEntity.setCodeField(referVo.getCodeField());
			oldEntity.setDataurl(referVo.getDataurl());
			oldEntity.setTreerelyurl(referVo.getTreerelyurl());
			oldEntity.setIdField(referVo.getIdField());
			oldEntity.setNameField(referVo.getNameField());
			oldEntity.setRefName(referVo.getRefName());
			oldEntity.setPageSize(referVo.getPageSize());
			oldEntity.setRefCode(referVo.getRefCode());
			oldEntity.setReferModule(referVo.getReferModule());
			oldEntity.setRefType(referVo.getRefType());
			oldEntity.setRemarks(referVo.getRemarks());
			oldEntity.setQueryMethod(referVo.getQueryMethod());
			oldEntity.setEnableBaseUrl(referVo.getEnableBaseUrl());
			oldEntity.setMultiRefCode(referVo.getMultiRefCode());
			oldEntity.setMultiRefName(referVo.getMultiRefName());
			oldEntity.setRelyfield(referVo.getRelyfield());
			oldEntity.setTreeShowFields(referVo.getTreeShowFields());
			entity = BeanMapper.map(oldEntity, ReferEntity.class);
		} else {
			// 校验编号是否重复
			List<ReferEntity> codeEntity = this.list(queryWrapper);
			if (codeEntity != null && codeEntity.size() > 0) {
				return CommonResponse.error("保存失败，参照编号已存在，请重新填写!!!");
			}
			// 新增
			referVo.setDr(0);
			entity = BeanMapper.map(referVo, ReferEntity.class);
		}
		this.saveOrUpdate(entity, syncEs);
		List<ReferShowfieldVO> attributos = referVo.getGridheaders();
		List<ReferShowfieldEntity> attributoEntitys = new ArrayList<>();
		List<Long> delattributosIds = new ArrayList<>();
		for (ReferShowfieldVO vo : attributos) {
			if (StringUtils.isNotBlank(vo.getRowState()) && vo.getRowState().equals("add")) {
				ReferShowfieldEntity en = BeanMapper.map(vo, ReferShowfieldEntity.class);
				en.setReferId(entity.getId());
				en.setDr(0);
				attributoEntitys.add(en);
			}
			if (StringUtils.isNotBlank(vo.getRowState()) && vo.getRowState().equals("edit")) {
				ReferShowfieldEntity en = BeanMapper.map(vo, ReferShowfieldEntity.class);
				attributoEntitys.add(en);
			}
			if (StringUtils.isNotBlank(vo.getRowState()) && vo.getRowState().equals("del")) {
				delattributosIds.add(vo.getId());
			}
		}
		if (attributoEntitys.size() > 0) {
			referShowfieldService.saveOrUpdateBatch(attributoEntitys, attributoEntitys.size(), syncEs);
		}
		if (delattributosIds.size() > 0) {
			referShowfieldService.removeByIds(delattributosIds, syncEs);
		}

		return CommonResponse.success("保存成功");
	}

	@Override
	public ReferVO queryDetail(Long id) {
		ReferEntity entity = super.getById(id);
		if (entity != null) {
			ReferVO vo = BeanMapper.map(entity, ReferVO.class);
			if (vo != null) {
				if (vo.getReferModule() != null) {
					ModuleEntity moduleEntity = moduleService.queryDetail(vo.getReferModule());
					if (moduleEntity != null) {
						vo.setReferModuleName(moduleEntity.getModuleName());
					}
				}
			}
			// 查询属性信息
			QueryWrapper<ReferShowfieldEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("refer_id", id);
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("show_order");
			List<ReferShowfieldEntity> fileds = referShowfieldService.querylist(queryWrapper);
			List<ReferShowfieldVO> vos = BeanMapper.mapList(fileds, ReferShowfieldVO.class);
			vo.setGridheaders(vos);
			return vo;
		}
		throw new BusinessException("未查询到该主键对应的详情");
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<Long> ids) {
		for (Long id : ids) {
			QueryParam queryParam = new QueryParam();
			Map<String, Parameter> paramMap = new HashMap<>();
			Parameter p = new Parameter("eq", id);
			paramMap.put("referId", p);
			queryParam.setParams(paramMap);
			List<ReferShowfieldEntity> attribute = referShowfieldService.queryList(queryParam, false);
			if (attribute != null && attribute.size() > 0) {
				List<Long> aIds = new ArrayList<>();
				for (ReferShowfieldEntity entity : attribute) {
					aIds.add(entity.getId());
				}
				referShowfieldService.delete(aIds);
			}
		}
		super.removeByIds(ids);
		return CommonResponse.success("删除成功");
	}

	@Override
	public ReferVO findByCode(String refCode) {
		ReferVO vo = new ReferVO();
		QueryParam queryParam = new QueryParam();
		Map<String, Parameter> paramMap = new HashMap<>();
		Parameter p = new Parameter("eq", refCode);
		paramMap.put("refCode", p);
		queryParam.setParams(paramMap);
		List<ReferEntity> pageData = this.queryList(queryParam, false);
		if (pageData != null && pageData.size() > 0) {
			ReferEntity en = pageData.get(0);
			vo = BeanMapper.map(en, ReferVO.class);
			if(vo.getEnableBaseUrl()){
				if(StringUtils.isNotBlank(vo.getTreerelyurl())&&!vo.getTreerelyurl().contains("http")){
					if(StringUtils.isNotBlank(baseHost)&& !"null".equals(baseHost)){
						vo.setTreerelyurl(baseHost+vo.getTreerelyurl());
					}else{
						vo.setTreerelyurl(environmentTools.getBaseHost()+vo.getTreerelyurl());
					}
				}
				if(StringUtils.isNotBlank(vo.getDataurl())&&!vo.getDataurl().contains("http")){
					if(StringUtils.isNotBlank(baseHost)&& !"null".equals(baseHost)){
						vo.setDataurl(baseHost+vo.getDataurl());
					}else{
						vo.setDataurl(environmentTools.getBaseHost()+vo.getDataurl());
					}
				}
			}
			QueryWrapper<ReferShowfieldEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("refer_id", en.getId());
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("show_order");
			List<ReferShowfieldEntity> fileds = referShowfieldService.querylist(queryWrapper);
			for(ReferShowfieldEntity filed : fileds){
				if(filed.getInnerFilter()){
					vo.setInnerFilter(true);
					if(StringUtils.isNotBlank(vo.getInnerFilterColumns())){
						String cloumn = vo.getInnerFilterColumns() + "," + filed.getCode();
						vo.setInnerFilterColumns(cloumn);
					}else{
						vo.setInnerFilterColumns(filed.getCode());
					}
				}
			}
			List<ReferShowfieldVO> vos = BeanMapper.mapList(fileds, ReferShowfieldVO.class);
			vo.setGridheaders(vos);
		}
		return vo;
	}

	@Override
	public IPage<ReferVO> pageList(QueryParam queryParam, boolean b) {
		IPage<ReferVO> backData = new Page<>();
		if(queryParam.getParams().get("referModule")!=null){
			String moduleId = queryParam.getParams().get("referModule").getValue().toString();
			List<ModuleVO> moduleVOs = moduleService.queryAllChildrenByPid(Long.parseLong(moduleId));
			List<Long> moduleIds = new ArrayList<>();
			for(ModuleVO vo : moduleVOs){
				moduleIds.add(vo.getId());
			}
			queryParam.getParams().get("referModule").setType("in");
			queryParam.getParams().get("referModule").setValue(moduleIds);
		}
		IPage<ReferEntity> pageData = this.queryPage(queryParam, false);
		List<ReferEntity> entitys = pageData.getRecords();
		List<ReferVO> vos = new ArrayList<>();
		ReferVO vo = null;
		for (ReferEntity entity : entitys) {
			vo = BeanMapper.map(entity, ReferVO.class);
			if (entity.getReferModule() != null) {
				 ModuleEntity moduleEntity = moduleService.queryDetail(entity.getReferModule());
				 if(moduleEntity!=null){
					 vo.setReferModuleName(moduleEntity.getModuleName());
				 }
			}
			vos.add(vo);
		}
		backData.setCurrent(pageData.getCurrent());
		backData.setPages(pageData.getPages());
		backData.setRecords(vos);
		backData.setSize(pageData.getSize());
		backData.setTotal(pageData.getTotal());
		return backData;
	}

}
