package com.ejianc.foundation.temporaryStorage.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.bean.ParamRegisterEntity;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IParamRegisterService;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.temporaryStorage.bean.TemporaryStorageEntity;
import com.ejianc.foundation.temporaryStorage.service.ITemporaryStorageService;
import com.ejianc.foundation.temporaryStorage.vo.TemporaryStorageVO;

/**
 * 暂存表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("temporaryStorage")
public class TemporaryStorageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ITemporaryStorageService service;

    @Autowired
    private IParamRegisterSetService paramRegisterSetService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemporaryStorageVO> saveOrUpdate(@RequestBody TemporaryStorageVO saveOrUpdateVO) {
    	TemporaryStorageEntity entity = new TemporaryStorageEntity();
    	if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            entity = BeanMapper.map(saveOrUpdateVO, TemporaryStorageEntity.class);
        }else{
            entity = service.getById(saveOrUpdateVO.getId());
            entity.setBillData(saveOrUpdateVO.getBillData());
            entity.setType(saveOrUpdateVO.getType());
            entity.setPcurl(saveOrUpdateVO.getPcurl());
            entity.setMaurl(saveOrUpdateVO.getMaurl());
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        entity.setCreateTime(new Date());
        if(entity.getBillTypeId()==null&&StringUtils.isNotBlank(entity.getBillTypeCode())){
            CommonResponse<BillTypeVO> billTypeVO = billTypeApi.getByCode(entity.getBillTypeCode());
            if(billTypeVO.isSuccess()&&billTypeVO.getData()!=null){
                entity.setBillTypeId(billTypeVO.getData().getId());
                entity.setBillTypeName(billTypeVO.getData().getBillName());
            }
        }
    	service.saveOrUpdate(entity, false);
    	TemporaryStorageVO vo = BeanMapper.map(entity, TemporaryStorageVO.class);
        ParamRegisterSetEntity paramRegisterSetEntity = paramRegisterSetService.getByCode("P-xQ51400179");
        if(paramRegisterSetEntity!=null){
            vo.setDay(paramRegisterSetEntity.getValueData());
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryStorageVO> queryDetail(Long id) {
    	TemporaryStorageEntity entity = service.selectById(id);
    	TemporaryStorageVO vo = BeanMapper.map(entity, TemporaryStorageVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryStorageVO> vos) {
//        service.removeByIds(vos.stream().map(TemporaryStorageVO::getId).collect(Collectors.toList()),true);
        service.deleteByIds(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description countTemporaryStorage
     * @param param
     * @Return
     */
    @RequestMapping(value = "/countTemporaryStorage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> countTemporaryStorage(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<TemporaryStorageEntity> page = service.queryPage(param,false);
        return CommonResponse.success("查询列表数据成功！",page.getTotal());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemporaryStorageVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TemporaryStorageEntity> page = service.queryPage(param,false);
        IPage<TemporaryStorageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryStorageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TemporaryStorageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TemporaryStorage-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTemporaryStorageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemporaryStorageVO>> refTemporaryStorageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TemporaryStorageEntity> page = service.queryPage(param,false);
        IPage<TemporaryStorageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryStorageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 定时清理
     * @Return void
     */
    @RequestMapping(value = "/cleanStorageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> cleanStorageData() {
        //获取定期处理天数
        QueryWrapper<ParamRegisterSetEntity> wapper = new QueryWrapper<>();
        wapper.eq("code", "P-xQ51400179");
        List<ParamRegisterSetEntity> list = paramRegisterSetService.list(wapper);
        List<TemporaryStorageVO> vos = new ArrayList<>();
        if(list!=null&&list.size()>0){
            List<Long> tenantIds = new ArrayList<Long>();
            String omsValueData = null;
            for(ParamRegisterSetEntity entity : list){
                tenantIds.add(entity.getTenantId());
                if(entity.getTenantId().equals(999999l)){
                    omsValueData = entity.getValueData();
                }
                Date date = getPastDate(Integer.parseInt(entity.getValueData()),new Date());
                //获取当前租户下可清理的暂存数据
                QueryWrapper<TemporaryStorageEntity> temporarywapper = new QueryWrapper<>();
                temporarywapper.eq("tenant_id", entity.getTenantId());
                temporarywapper.le("create_time", date);
                List<TemporaryStorageEntity> temporarylist = service.list(temporarywapper);
                if(temporarylist!=null&&temporarylist.size()>0){
                    vos.addAll(BeanMapper.mapList(temporarylist,TemporaryStorageVO.class));
                }
            }
            if(tenantIds!=null && tenantIds.size()>0){
                Date date = getPastDate(Integer.parseInt(omsValueData),new Date());
                //获取当前租户下可清理的暂存数据
                QueryWrapper<TemporaryStorageEntity> temporarywapper = new QueryWrapper<>();
                temporarywapper.notIn("tenant_id", tenantIds);
                temporarywapper.le("create_time", date);
                List<TemporaryStorageEntity> temporarylist = service.list(temporarywapper);
                if(temporarylist!=null&&temporarylist.size()>0){
                    vos.addAll(BeanMapper.mapList(temporarylist,TemporaryStorageVO.class));
                }
            }
        }
        if(vos!=null&&vos.size()>0){
            service.deleteByIds(vos);
        }
        return CommonResponse.success("定时清理数据成功！");
    }
    /**
     * 获取前 N天 的日期
     * @param pastDay 天为单位
     * @param newDate  以那个日期为临界点
     * @return
     */
    public static Date getPastDate(int pastDay,Date newDate){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - pastDay);
        Date resultDate = calendar.getTime();
        return resultDate;
    }
}
