/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.SupplierCommentModleEntity;
import com.ejianc.foundation.supplier.service.ISupplierCommentModleService;
import com.ejianc.foundation.supplier.util.ExcelImportUtil;
import com.ejianc.foundation.supplier.util.TreeNodeBUtil;
import com.ejianc.foundation.supplier.vo.SupplierComModleContentVO;
import com.ejianc.foundation.supplier.vo.SupplierCommentModleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"commentModel"})
public class SupplierCommentModleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZY_SUPPLIER_COMMENT_CODE";
    @Autowired
    private ISupplierCommentModleService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierCommentModleVO> saveOrUpdate(@RequestBody SupplierCommentModleVO saveOrUpdateVO) {
        SupplierCommentModleEntity entity = (SupplierCommentModleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierCommentModleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getState().booleanValue()) {
            QueryParam params = new QueryParam();
            params.getParams().put("commentType", new Parameter("eq", (Object)entity.getCommentType()));
            params.getParams().put("state", new Parameter("eq", (Object)true));
            params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            List lists = this.service.queryList(params);
            if (ListUtil.isNotEmpty((List)lists)) {
                for (SupplierCommentModleEntity modle : lists) {
                    modle.setState(false);
                }
                this.service.saveOrUpdateBatch(lists);
            }
        }
        SupplierCommentModleVO vo = (SupplierCommentModleVO)BeanMapper.map((Object)((Object)entity), SupplierCommentModleVO.class);
        if (CollectionUtils.isNotEmpty(entity.getSupplierComModleContentList())) {
            vo.setSupplierComModleContentList(TreeNodeBUtil.buildTree((List)vo.getSupplierComModleContentList()));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCommentModleVO> queryDetail(Long id) {
        SupplierCommentModleEntity entity = (SupplierCommentModleEntity)((Object)this.service.selectById(id));
        SupplierCommentModleVO vo = (SupplierCommentModleVO)BeanMapper.map((Object)((Object)entity), SupplierCommentModleVO.class);
        if (CollectionUtils.isNotEmpty(entity.getSupplierComModleContentList())) {
            vo.setSupplierComModleContentList(TreeNodeBUtil.buildTree((List)vo.getSupplierComModleContentList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierCommentModleVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierCommentModleVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierCommentModleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierCommentModle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierCommentModleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierCommentModleVO>> refCommentModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)true));
        String commentType = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            commentType = conditionJson.getString("commentType");
        }
        if (StringUtils.isNotEmpty(commentType)) {
            param.getParams().put("commentType", new Parameter("eq", (Object)commentType));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierCommentModleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCommentModleVO> querySubList(Long zid) {
        SupplierCommentModleEntity entity = (SupplierCommentModleEntity)((Object)this.service.selectById(zid));
        SupplierCommentModleVO vo = (SupplierCommentModleVO)BeanMapper.map((Object)((Object)entity), SupplierCommentModleVO.class);
        if (CollectionUtils.isNotEmpty(entity.getSupplierComModleContentList())) {
            vo.setSupplierComModleContentList(TreeNodeBUtil.buildTree((List)vo.getSupplierComModleContentList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTypeNameList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCommentModleVO> queryTypeNameList(String supplyType, String commentType) {
        SupplierCommentModleEntity commentModleEntity = this.service.queryTypeName(supplyType, commentType);
        if (commentModleEntity != null && (commentModleEntity = (SupplierCommentModleEntity)((Object)this.service.selectById(commentModleEntity.getId()))) != null) {
            SupplierCommentModleVO vo = (SupplierCommentModleVO)BeanMapper.map((Object)((Object)commentModleEntity), SupplierCommentModleVO.class);
            if (CollectionUtils.isNotEmpty(commentModleEntity.getSupplierComModleContentList())) {
                vo.setSupplierComModleContentList(TreeNodeBUtil.buildTree((List)vo.getSupplierComModleContentList()));
                return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
            }
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u751f\u6548\u7684\u8bc4\u4ef7\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6a21\u677f\u540e\u518d\u8bd5\uff01");
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"commentModle-import.xlsx", (String)"\u8bc4\u4ef7\u5185\u5bb9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<SupplierComModleContentVO> errorsList = new ArrayList<SupplierComModleContentVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList falseList;
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SupplierComModleContentVO> detailVoList = new ArrayList<SupplierComModleContentVO>();
            HashMap<String, Long> tidMap = new HashMap<String, Long>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SupplierComModleContentVO vo = new SupplierComModleContentVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                Long id = IdWorker.getId();
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        parentWarn = true;
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    } else {
                        vo.setParentId(Long.valueOf(999L));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                    vo.setParentId(Long.valueOf(999L));
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setCode(null);
                    flag = true;
                } else {
                    vo.setCode((String)datas.get(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    if (parentWarn) {
                        vo.setName(null);
                    } else {
                        vo.setName((String)datas.get(1));
                    }
                } else if (!parentWarn) {
                    vo.setName(null);
                    vo.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8003\u6838\u5185\u5bb9\u5fc5\u586b\uff01");
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    if (parentWarn) {
                        vo.setItem((String)datas.get(2));
                    } else {
                        vo.setItem(null);
                    }
                } else if (parentWarn) {
                    vo.setItem(null);
                    vo.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6263\u5206\u4e8b\u9879\u5fc5\u586b\uff01");
                }
                if (parentWarn) {
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                        try {
                            vo.setDeduct(Integer.valueOf((String)datas.get(3)));
                        }
                        catch (NumberFormatException e) {
                            vo.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6263\u5206\u503c\u4e0d\u662f\u6b63\u786e\u7684\u6570\u5b57\u683c\u5f0f\uff01");
                            vo.setDeduct(null);
                        }
                    }
                } else {
                    vo.setDeduct(null);
                }
                parentWarn = false;
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setShadowId(vo.getTid());
                vo.setRowState("add");
                vo.setEditFlag(Boolean.valueOf(false));
                if (StringUtils.isNotBlank((CharSequence)vo.getErrorMessage())) {
                    errorsList.add(vo);
                    continue;
                }
                detailVoList.add(vo);
            }
            for (SupplierComModleContentVO tVo : detailVoList) {
                tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            List allList = ExcelImportUtil.separate((List)mapList, falseList = new ArrayList());
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            if (errorList.size() > 0) {
                resp.put("errorList", (Object)errorList);
                resp.put("errorNum", (Object)errorList.size());
            } else {
                resp.put("errorList", errorsList);
                resp.put("errorNum", (Object)0);
            }
            resp.put("successList", allList.get(0));
            resp.put("successNum", (Object)(result.size() - 1 - errorList.size()));
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/updateState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String, String> param) {
        Long id = Long.parseLong(param.get("id"));
        Boolean state = Boolean.parseBoolean(param.get("state"));
        this.service.updateState(id, state);
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f!");
    }
}

