/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.lock;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.lock.IBillCodeEngineLock;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisException;

@Component
public class RedisLock
implements IBillCodeEngineLock {
    private Logger logger = LoggerFactory.getLogger(RedisLock.class);
    private static final ThreadLocal<String> idStore = new ThreadLocal();
    private final String LOCK_KEY_PREFIX = "lock_ejc_billcode:";
    private final String LOCK_KEY_SEPERATOR = "_";
    @Autowired
    private JedisPool jedisPool;

    @Override
    public int getEngineLockType() {
        return 2;
    }

    @Override
    public boolean lock(String pk_bilcodebase, String billCodeSNRefer, Long tenantId) throws BillCodeException {
        String lockKey = "lock_ejc_billcode:" + pk_bilcodebase + "_" + billCodeSNRefer.replaceAll("\\^", "") + "_" + tenantId;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            long end1 = System.currentTimeMillis();
            long acquireTimeout = 100000L;
            long timeout = 500L;
            long end = System.currentTimeMillis() + acquireTimeout;
            while (System.currentTimeMillis() < end) {
                String identifier = UUID.randomUUID().toString();
                String result = jedis.set(lockKey, identifier, "NX", "PX", timeout);
                if ("OK".equals(result)) {
                    idStore.set(identifier);
                    this.logger.info(Thread.currentThread().getId() + "RedisLock\u83b7\u53d6RedisLock--" + System.currentTimeMillis() + "-----" + (System.currentTimeMillis() - end1));
                    boolean bl = true;
                    return bl;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return false;
    }

    @Override
    public boolean unlock(String pk_bilcodebase, String billCodeSNRefer, Long tenantId) throws BillCodeException {
        String lockKey = "lock_ejc_billcode:" + pk_bilcodebase + "_" + billCodeSNRefer.replaceAll("\\^", "") + "_" + tenantId;
        Jedis jedis = null;
        boolean retFlag = false;
        try {
            block7: {
                List results;
                jedis = this.jedisPool.getResource();
                do {
                    jedis.watch(new String[]{lockKey});
                    if (!idStore.get().equals(jedis.get(lockKey))) break block7;
                    Transaction transaction = jedis.multi();
                    transaction.del(lockKey);
                    results = transaction.exec();
                } while (results == null);
                retFlag = true;
            }
            jedis.unwatch();
        }
        catch (JedisException e) {
            throw new JedisException((Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
                idStore.remove();
            }
        }
        return retFlag;
    }
}

