package com.ejianc.foundation.support.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.*;
import com.ejianc.foundation.support.service.*;
import com.ejianc.foundation.support.vo.PublishDataVO;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.support.mapper.DataTransferMapper;
import com.ejianc.framework.core.response.CommonResponse;

@Service
public class DataTransferService implements IDataTransferService {

	private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private DataTransferMapper dataTransferMapper;
	@Autowired
	private SqlSessionTemplate sqlSessionTemplate;
	@Autowired
	private IReferService referService;
	@Autowired
	private IReferShowfieldService referShowfieldService;
	@Autowired
	private IBillCodeRuleService billTypeRuleService;
	@Autowired
	private IBillCodeRuleAttrService billCodeRuleAttrService;
	@Autowired
	private IBillTypeService billTypeService;

	@Autowired
	private IDefdocService defdocService;
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private IDefdocAttrService defdocAttrServiceImpl;
	@Autowired
	private IModuleService moduleService;
	@Autowired
	private IParamRegisterService paramRegisterService;
	@Autowired
	private IBillParamService billParamService;

	@Override
	public CommonResponse<String> executeSql(List<String> sqls) {
		SqlSession session = sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
		LOGGER.info("待发布sql:{}", JSONObject.toJSONString(sqls));
		try {
			String sqlUnion = "";
	        for (int i = 0; i < sqls.size(); i++) {
	        	sqlUnion += sqls.get(i);
	            if (i != 0 && (i % 400 == 0 || i == (sqls.size() - 1))) {
	            	dataTransferMapper.executeSql(sqlUnion);
	                //手动每400条提交一次，提交后无法回滚
	                session.commit();
	                //清理缓存，防止溢出
	                session.clearCache();
					LOGGER.info("发布成功的sql:{}",sqlUnion);
	                sqlUnion = "";
	            }
	        }
	    } catch (Exception e) {
	        //没有提交的数据可以回滚
			LOGGER.error("1执行SQL失败：{}",e.getMessage());
			LOGGER.error("2执行SQL失败",e);
	        session.rollback();
	        e.printStackTrace();
			return CommonResponse.error("存在发布失败数据，请查看日志！");
	    } finally {
	        session.close();
	    }
//		String sqlUnion = "";
//		for(String sql : sqls){
//			sqlUnion += (sql+";");
//		}
//		dataTransferMapper.executeSql(sqlUnion);
		return CommonResponse.success("发布成功");
	}

	@Override
	public void transferBySql(PublishDataVO vo) {
		/*************参照start*************/
		if("refer".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String fieldTableName = "ejc_support_refer_showfield";
			String baseTableName = "ejc_support_refer";
			String deleteFieldSql = " delete from " + fieldTableName + " where refer_id in " + idStr + ";";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteFieldSql);
			dataTransferMapper.executeSql(deleteBaseSql);

			if(vo.getReferEntities()!=null && vo.getReferEntities().size()>0){
				referService.saveOrUpdateBatch(vo.getReferEntities(), vo.getReferEntities().size(), false);
			}
			if(vo.getReferShowfieldEntities()!=null && vo.getReferShowfieldEntities().size()>0){
				referShowfieldService.saveOrUpdateBatch(vo.getReferShowfieldEntities(), vo.getReferShowfieldEntities().size(), false);
			}
		}
		/*************参照end*************/

		/*************单据编码规则start*************/
		if("billCodeRule".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_support_billcode_rule";
			String ruleAttrTableName = "ejc_support_billcode_rule_attr";
			String deleteRuleAttrSql = " delete from " + ruleAttrTableName + " where billcode_rule_Id in " + idStr + ";";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);
			dataTransferMapper.executeSql(deleteRuleAttrSql);

			if(vo.getBillCodeRuleEntities()!=null && vo.getBillCodeRuleEntities().size()>0){
				billTypeRuleService.saveOrUpdateBatch(vo.getBillCodeRuleEntities(), vo.getBillCodeRuleEntities().size(), false);
			}
			if(vo.getBillCodeRuleAttrEntities()!=null && vo.getBillCodeRuleAttrEntities().size()>0){
				billCodeRuleAttrService.saveOrUpdateBatch(vo.getBillCodeRuleAttrEntities(), vo.getBillCodeRuleAttrEntities().size(), false);
			}
		}
		/*************单据编码规则end*************/

		/*************单据类型start*************/
		if("billType".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_support_billtype";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);
			if(vo.getBillTypeEntities()!=null && vo.getBillTypeEntities().size()>0){
				billTypeService.saveOrUpdateBatch(vo.getBillTypeEntities(), vo.getBillTypeEntities().size(), false);
			}
		}
		/*************单据类型end*************/

		/*************自定义档案start*************/
		if("defdoc".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_support_defdoc";
			String detailName = "ejc_support_defdoc_detail";
			String attrName = "ejc_support_defdoc_attribute";
			String attrSql = " delete from " + attrName + " where pid in " + idStr + ";";
			String detailSql = " delete from " + detailName + " where tenant_id = 999999 and defdoc_id in " + idStr + ";";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(attrSql);
			dataTransferMapper.executeSql(detailSql);
			dataTransferMapper.executeSql(deleteBaseSql);

			if(vo.getDefdocEntities()!=null && vo.getDefdocEntities().size()>0){
				defdocService.saveOrUpdateBatch(vo.getDefdocEntities(), vo.getDefdocEntities().size(), false);
			}
			if(vo.getDefdocDetailEntities()!=null && vo.getDefdocDetailEntities().size()>0){
				defdocDetailService.saveOrUpdateBatch(vo.getDefdocDetailEntities(), vo.getDefdocDetailEntities().size(), false);
			}
			if(vo.getDefdocAttrEntites()!=null && vo.getDefdocAttrEntites().size()>0){
				defdocAttrServiceImpl.saveOrUpdateBatch(vo.getDefdocAttrEntites(), vo.getDefdocAttrEntites().size(), false);
			}

		}
		/*************自定义档案end*************/

		/*************模块start*************/
		if("module".equals(vo.getType())){
			String idStr = "";
			idStr = "(" + vo.getModuleEntity().getId() + ")";
			String baseTableName = "ejc_support_module";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);
			if(vo.getModuleEntity()!=null){
				moduleService.saveOrUpdate(vo.getModuleEntity(), false);
			}
		}
		/*************模块end*************/

		/*************系统参数start*************/
		if("sysParam".equals(vo.getType())) {
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_p_register";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);
			if (vo.getParamRegisterEntities() != null && vo.getParamRegisterEntities().size() > 0) {
				paramRegisterService.saveOrUpdateBatch(vo.getParamRegisterEntities(), vo.getParamRegisterEntities().size(), false);
			}
		}
		/*************系统参数end*************/

		/*************单据参数start*************/
		if("billParam".equals(vo.getType())) {
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_bill_param";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);
			if (vo.getBillParamEntities() != null && vo.getBillParamEntities().size() > 0) {
				billParamService.saveOrUpdateBatch(vo.getBillParamEntities(), vo.getBillParamEntities().size(), false);
			}
		}
		/*************单据参数end*************/
	}

}
