package com.ejianc.foundation.share.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.CustomerLinkerEntity;
import com.ejianc.foundation.share.mapper.CustomerMapper;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomerServiceImpl extends BaseServiceImpl<CustomerMapper, CustomerEntity> implements ICustomerService {

	private static final String CUSTOMER_BILL_CODE = "SUPPORT_CUSTOMER";
	
	@Autowired
	private CustomerMapper customerMapper;
	@Autowired
	private ICustomerLinkerService customerLinkerService;
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private IBillCodeGenerator generator;
	@Autowired
	private ICustomerCategoryService customerCategoryService;
	

	@Override
	public List<CustomerVO> queryListByCategoryId(Long categoryId) {
		QueryWrapper<CustomerEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("category_id", categoryId);
		List<CustomerEntity> entities = customerMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, CustomerVO.class);
		}
		return null;
	}


	@Override
	public CommonResponse<String> saveOrUpdate(CustomerVO customerVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		CustomerEntity entity = null;
		String operateType = null;
		if(customerVo.getCategoryId()==null){
			return CommonResponse.error("客户分类不能为空!");
		}
		//根据统一信用代码验重
		this.check(customerVo);

		if(customerVo.getId() != null && customerVo.getId() > 0) { //修改
			entity = customerMapper.selectById(customerVo.getId());
			entity.setCode(customerVo.getCode());
			entity.setCategoryId(customerVo.getCategoryId());
			entity.setCategoryName(customerVo.getCategoryName());
			entity.setName(customerVo.getName());
			entity.setSocialCreditCode(customerVo.getSocialCreditCode());
			entity.setLegal(customerVo.getLegal());
			entity.setTaxPayerType(customerVo.getTaxPayerType());
			entity.setCustomerType(customerVo.getCustomerType());
			entity.setArea(customerVo.getArea());
			entity.setAddress(customerVo.getAddress());
			entity.setTelephone(customerVo.getTelephone());
			entity.setBankName(customerVo.getBankName());
			entity.setBankAccount(customerVo.getBankAccount());
			entity.setBankCode(customerVo.getBankCode());
			entity.setDescription(customerVo.getDescription());
			entity.setAreaStr(customerVo.getAreaStr());
			entity.setAddressAndPhone(customerVo.getAddressAndPhone());
			
			operateType = "edit";
		}else{ //新增
			try {
				if(StringUtils.isEmpty(customerVo.getCode())){
					String billCode = generator.generateBillCodeById(CUSTOMER_BILL_CODE, tenantId);
					customerVo.setCode(billCode);
				}
			} catch (BillCodeException e) {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			entity = BeanMapper.map(customerVo, CustomerEntity.class);
			
			operateType = "add";
		}
		super.saveOrUpdate(entity);
		
		//子表
		List<CustomerLinkerVO> customerLinkerVos = customerVo.getGridheaders();
		List<CustomerLinkerEntity> saveOrUpldates = new ArrayList<>();
		List<Long> deleteIds = new ArrayList<>();
		for(CustomerLinkerVO customerLinkerVo:customerLinkerVos) {
			if("add".equals(customerLinkerVo.getRowState())) {
				CustomerLinkerEntity customerLinkerEntity = BeanMapper.map(customerLinkerVo, CustomerLinkerEntity.class);
				customerLinkerEntity.setCustomerId(entity.getId());
				saveOrUpldates.add(customerLinkerEntity);
			}else if("edit".equals(customerLinkerVo.getRowState())) {
				CustomerLinkerEntity customerLinkerEntity = BeanMapper.map(customerLinkerVo, CustomerLinkerEntity.class);
				saveOrUpldates.add(customerLinkerEntity);
			} else if("del".equals(customerLinkerVo.getRowState())) {
				deleteIds.add(customerLinkerVo.getId());
			}
		}
		if(saveOrUpldates.size() > 0) {
			customerLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
		}
		if(deleteIds.size() > 0) {
			customerLinkerService.removeByIds(deleteIds, false);
		}
		
		if("add".equals(operateType)) {
			return CommonResponse.success("保存成功");
		}else{
			return CommonResponse.success("修改成功");
		}
	}

	private void check(CustomerVO customerVo) {
		QueryWrapper<CustomerEntity> queryWrapper = new QueryWrapper<>();
		if(customerVo.getId()!=null){
			queryWrapper.ne("id", customerVo.getId());
		}
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("social_credit_code", customerVo.getSocialCreditCode());
		List<CustomerEntity> list = this.list(queryWrapper );
		if(list!=null&&list.size()>0){
			throw new BusinessException("统一社会信用代码已存在！！！");
		}
	}

	@Override
	public CustomerVO queryDetail(Long id) {
		CustomerEntity entity = customerMapper.selectById(id);
		if(entity != null) {
			CustomerVO customerVo = BeanMapper.map(entity, CustomerVO.class);
			
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("customerId", new Parameter(QueryParam.EQ, customerVo.getId()));
			queryParam.getOrderMap().put("createTime", "desc");
			List<CustomerLinkerEntity> customerLinkers = customerLinkerService.queryList(queryParam, false);
			if(customerLinkers != null && customerLinkers.size() > 0) {
				List<CustomerLinkerVO> customerLinkerVos = BeanMapper.mapList(customerLinkers, CustomerLinkerVO.class);
				customerVo.setGridheaders(customerLinkerVos);
			}
			return customerVo;
		}
		return null;
	}

	@Override
	public void deleteCustomer(List<Long> ids) {
		for(Long id:ids) {
			//先删除客户联系人
			customerLinkerService.deleteByCustomerId(id);
			
			customerMapper.deleteById(id);
		}
	}


	@Override
	public IPage<CustomerVO> queryPageList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				if(StringUtils.isNotBlank(entry.getValue().getValue().toString())){
					CustomerCategoryEntity categoryEntity = customerCategoryService.queryDetail(Long.parseLong(entry.getValue().getValue().toString()));
					if(categoryEntity != null) {
						condition.put("innerCode", categoryEntity.getInnerCode());
					}
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		if(StringUtils.isNotBlank(queryParam.getSearchText())) {
			condition.put("searchText", queryParam.getSearchText());
		}

		List<CustomerEntity> customerEntities = customerMapper.queryList(condition);
		Long count = customerMapper.queryCount(condition);
		
		List<CustomerVO> customerVos = new ArrayList<CustomerVO>();
		CustomerVO customerVo = null;
		Map<Long,String> defMap = new HashMap<>();
		for(CustomerEntity entity:customerEntities) {
			customerVo = BeanMapper.map(entity, CustomerVO.class);

			if(customerVo.getTaxPayerType()!=null){
				if(defMap.get(customerVo.getTaxPayerType())!=null){
					customerVo.setTaxPayerTypeName(defMap.get(customerVo.getTaxPayerType()));
				}else{
					DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(customerVo.getTaxPayerType());
					if(taxPayerTypeVo != null) {
						customerVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
						defMap.put(customerVo.getTaxPayerType(), taxPayerTypeVo.getName());
					}
				}
			}

			if(customerVo.getCustomerType()!=null){
				if(defMap.get(customerVo.getCustomerType())!=null){
					customerVo.setCustomerTypeName(defMap.get(customerVo.getCustomerType()));
				}else{
					DefdocDetailVO customerTypeVo = defdocDetailService.queryDetail(customerVo.getCustomerType());
					if(customerTypeVo != null) {
						customerVo.setCustomerTypeName(customerTypeVo.getName());
						defMap.put(customerVo.getCustomerType(), customerTypeVo.getName());
					}
				}
			}
			
			customerVos.add(customerVo);
		}
		
		IPage<CustomerVO> resultPage = new Page<>();
		resultPage.setCurrent(queryParam.getPageIndex());
		resultPage.setRecords(customerVos);
		resultPage.setTotal(count);
		
//		IPage<CustomerEntity> customerEntityIPage = super.queryPage(queryParam,false);
//		List<CustomerEntity> customerEntities = customerEntityIPage.getRecords();
//		List<CustomerVO> customerVos = new ArrayList<>();
//		CustomerVO customerVo = null;
//		for(CustomerEntity entity:customerEntities) {
//			customerVo = BeanMapper.map(entity, CustomerVO.class);
//			
//			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(customerVo.getTaxPayerType());
//			if(taxPayerTypeVo != null) {
//				customerVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
//			}
//			
//			DefdocDetailVO customerTypeVo = defdocDetailService.queryDetail(customerVo.getCustomerType());
//			if(customerTypeVo != null) {
//				customerVo.setCustomerTypeName(customerTypeVo.getName());
//			}
//			
//			customerVos.add(customerVo);
//		}
//		IPage<CustomerVO> resultPage = new Page<>();
//		resultPage.setCurrent(customerEntityIPage.getCurrent());
//		resultPage.setPages(customerEntityIPage.getPages());
//		resultPage.setRecords(customerVos);
//		resultPage.setSize(customerEntityIPage.getSize());
//		resultPage.setTotal(customerEntityIPage.getTotal());
		return resultPage;
	}


	@Override
	public List<CustomerVO> queryExportList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<CustomerEntity> customerEntities = customerMapper.queryExportList(condition);
		
		List<CustomerVO> customerVos = new ArrayList<CustomerVO>();
		CustomerVO customerVo = null;
		for(CustomerEntity entity:customerEntities) {
			customerVo = BeanMapper.map(entity, CustomerVO.class);
			
			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(customerVo.getTaxPayerType());
			if(taxPayerTypeVo != null) {
				customerVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
			}
			
			DefdocDetailVO customerTypeVo = defdocDetailService.queryDetail(customerVo.getCustomerType());
			if(customerTypeVo != null) {
				customerVo.setCustomerTypeName(customerTypeVo.getName());
			}
			
			QueryParam linkerQueryParam = new QueryParam();
			linkerQueryParam.getParams().put("customerId", new Parameter(QueryParam.EQ, customerVo.getId()));
			List<CustomerLinkerEntity> linkerEntities = customerLinkerService.queryList(linkerQueryParam, false);
			if(linkerEntities != null && linkerEntities.size() > 0) {
				CustomerLinkerEntity linkerEntity = linkerEntities.get(0);
				customerVo.setLinkman(linkerEntity.getLinkman());
				customerVo.setCellphone(linkerEntity.getCellphone());
			}
			customerVos.add(customerVo);
		}
		
		return customerVos;
	}


	@Override
	public CustomerVO queryDetailBySocialCode(String socialCode) {
		QueryWrapper<CustomerEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("social_credit_code", socialCode);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<CustomerEntity> entities = customerMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), CustomerVO.class);
		}
		return null;
	}

	@Override
	public CustomerVO syncCustomer(CustomerVO customerVO) {
		QueryWrapper<CustomerEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_id", customerVO.getSourceId());
		List<CustomerEntity> entities = customerMapper.selectList(queryWrapper);
		CustomerEntity entity = null;
		if(entities != null && entities.size() > 0) {
			entity = entities.get(0);
			entity.setCode(customerVO.getCode());
			entity.setName(customerVO.getName());
			entity.setSocialCreditCode(customerVO.getSocialCreditCode());
			entity.setTaxPayerType(customerVO.getTaxPayerType());
			entity.setAddress(customerVO.getAddress());
			entity.setBankAccount(customerVO.getBankAccount());
			entity.setBankCode(customerVO.getBankCode());
			entity.setBankName(customerVO.getBankName());
			entity.setLegal(customerVO.getLegal());
			entity.setTelephone(customerVO.getCellphone());
		}else{
			entity = BeanMapper.map(customerVO, CustomerEntity.class);
		}
		this.saveOrUpdate(entity, false);
		return BeanMapper.map(entity, CustomerVO.class);
	}

}
