package com.ejianc.foundation.supplier.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.vo.SupplierGradeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商等级
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplierGrade")
public class SupplierGradeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierGradeService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierGradeVO> saveOrUpdate(@RequestBody SupplierGradeVO saveOrUpdateVO) {
    	SupplierGradeEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierGradeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
        }
    	service.saveOrUpdate(entity, false);
    	SupplierGradeVO vo = BeanMapper.map(entity, SupplierGradeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierGradeVO> queryDetail(Long id) {
    	SupplierGradeEntity entity = service.selectById(id);
    	SupplierGradeVO vo = BeanMapper.map(entity, SupplierGradeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierGradeVO> vos) {
        service.removeByIds(vos.stream().map(SupplierGradeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierGradeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SupplierGradeEntity> page = service.queryPage(param,false);
        IPage<SupplierGradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierGradeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
