package com.ejianc.foundation.supplier.controller.api;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.supplier.bean.SupplerIncidentContentEntity;
import com.ejianc.foundation.supplier.bean.SupplerIncidentEntity;
import com.ejianc.foundation.supplier.bean.SupplierComModleContentEntity;
import com.ejianc.foundation.supplier.bean.SupplierCommentModleEntity;
import com.ejianc.foundation.supplier.controller.SupplerIncidentController;
import com.ejianc.foundation.supplier.service.ISupplerIncidentService;
import com.ejianc.foundation.supplier.service.ISupplierCommentModleService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.util.ContractPerformanceStateEnum;
import com.ejianc.foundation.supplier.vo.ContractInfoVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.Date;

@Controller
@RequestMapping("api/supplierZY")
public class SupplierZYApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISupplerIncidentService supplerIncidentService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private ISupplierCommentModleService commentModleService;
    @RequestMapping(value = "/createGuoChengPingJia", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> createGuoChengPingJia(@RequestBody ContractInfoVO e) {
        if(e.getContractId() == null){
            return CommonResponse.error("合同id不能为空。");
        }
        if(e.getContractName() == null){
            return CommonResponse.error("合同名称不能为空");
        }
        if(e.getContractCode() == null){
            return CommonResponse.error("合同编码不能为空");
        }
        if(e.getPartybId() == null){
            return CommonResponse.error("乙方（供应商）id不能为空");
        }
        if(e.getPartybName() == null){
            return CommonResponse.error("乙方（供应商）名称不能为空");
        }
        if(e.getOrgId() == null){
            return CommonResponse.error("项目部组织id不能为空");
        }
        if(e.getOrgName() == null){
            return CommonResponse.error("项目部组织名称不能为空");
        }
        if(e.getOrgCode() == null){
            return CommonResponse.error("项目部组织编码不能为空");
        }
        if(e.getProjectId() == null){
            return CommonResponse.error("项目id不能为空");
        }
        if(e.getProjectName() == null){
            return CommonResponse.error("项目名称不能为空");
        }
        SupplerIncidentEntity entity = new SupplerIncidentEntity();
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SupplerIncidentController.ZY_SUPPLIER_GCPJ_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        }else{
            entity.setCode("GCPJ-"+ IdWorker.getId());//此处需要根据实际修改 删除本行或者下一行
        }
        entity.setContractId(e.getContractId());
        entity.setContractName(e.getContractName());
        entity.setContractCode(e.getContractCode());
        entity.setSupplyId(e.getPartybId());
        entity.setSupplyName(e.getPartybName());
        entity.setOrgId(e.getOrgId());
        entity.setOrgName(e.getOrgName());
        entity.setOrgCode(e.getOrgCode());
        entity.setProjectId(e.getProjectId());
        entity.setProjectName(e.getProjectName());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setPerformanceStatus(e.getPerformanceStatus());
        entity.setStatus(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setContractAmount(e.getContractTaxMny());
        entity.setParentOrgId(e.getParentOrgId());
        entity.setParentOrgName(e.getParentOrgName());
        entity.setParentOrgCode(e.getParentOrgCode());
        entity.setHeadUserId(e.getSupplierProjectManagerId());
        entity.setHeadUserName(e.getSupplierProjectManagerName());
        entity.setDate(new Date());
        if (ContractPerformanceStateEnum.已终止.getStateCode().equals(e.getPerformanceStatus())) {
            entity.setSource("最终结算");
        } else {
            entity.setSource("定时推送");
        }
        entity.setBuckleBranch(BigDecimal.ZERO);
        supplerIncidentService.saveOrUpdate(entity, false);
        return CommonResponse.error("操作成功！", entity.getId());
    }

    /**
     * 同步
     * @param
     * @return
     */
    @RequestMapping(value = "syncSuppler",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierVO> syncSuppler(@RequestBody SupplierVO supplierVO) {
        SupplierVO vo = supplierService.syncSuppler(supplierVO);
        return CommonResponse.success("同步成功！", vo);
    }
}
