/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.mapper.DataTransferMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.foundation.support.service.IDefdocAttrService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IParamRegisterService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.service.IReferShowfieldService;
import com.ejianc.foundation.support.vo.PublishDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataTransferService
implements IDataTransferService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DataTransferMapper dataTransferMapper;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private IReferService referService;
    @Autowired
    private IReferShowfieldService referShowfieldService;
    @Autowired
    private IBillCodeRuleService billTypeRuleService;
    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private IDefdocService defdocService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IDefdocAttrService defdocAttrServiceImpl;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IParamRegisterService paramRegisterService;
    @Autowired
    private IBillParamService billParamService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> executeSql(List<String> sqls) {
        this.LOGGER.info("\u5f85\u53d1\u5e03sql:{}", (Object)JSONObject.toJSONString(sqls));
        try (SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);){
            String sqlUnion = "";
            for (int i = 0; i < sqls.size(); ++i) {
                sqlUnion = sqlUnion + sqls.get(i);
                if (i == 0 || i % 400 != 0 && i != sqls.size() - 1) continue;
                this.dataTransferMapper.executeSql(sqlUnion);
                session.commit();
                session.clearCache();
                this.LOGGER.info("\u53d1\u5e03\u6210\u529f\u7684sql:{}", (Object)sqlUnion);
                sqlUnion = "";
            }
        }
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public void transferBySql(PublishDataVO vo) {
        String deleteBaseSql;
        Object baseTableName;
        String deleteBaseSql2;
        String idStr;
        if ("refer".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            String fieldTableName = "ejc_support_refer_showfield";
            String baseTableName2 = "ejc_support_refer";
            String deleteFieldSql = " delete from " + (String)fieldTableName + " where refer_id in " + idStr + ";";
            deleteBaseSql2 = " delete from " + baseTableName2 + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteFieldSql);
            this.dataTransferMapper.executeSql(deleteBaseSql2);
            if (vo.getReferEntities() != null && vo.getReferEntities().size() > 0) {
                this.referService.saveOrUpdateBatch(vo.getReferEntities(), vo.getReferEntities().size(), false);
            }
            if (vo.getReferShowfieldEntities() != null && vo.getReferShowfieldEntities().size() > 0) {
                this.referShowfieldService.saveOrUpdateBatch(vo.getReferShowfieldEntities(), vo.getReferShowfieldEntities().size(), false);
            }
        }
        if ("billCodeRule".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            baseTableName = "ejc_support_billcode_rule";
            String ruleAttrTableName = "ejc_support_billcode_rule_attr";
            String deleteRuleAttrSql = " delete from " + ruleAttrTableName + " where billcode_rule_Id in " + idStr + ";";
            deleteBaseSql2 = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteBaseSql2);
            this.dataTransferMapper.executeSql(deleteRuleAttrSql);
            if (vo.getBillCodeRuleEntities() != null && vo.getBillCodeRuleEntities().size() > 0) {
                this.billTypeRuleService.saveOrUpdateBatch(vo.getBillCodeRuleEntities(), vo.getBillCodeRuleEntities().size(), false);
            }
            if (vo.getBillCodeRuleAttrEntities() != null && vo.getBillCodeRuleAttrEntities().size() > 0) {
                this.billCodeRuleAttrService.saveOrUpdateBatch(vo.getBillCodeRuleAttrEntities(), vo.getBillCodeRuleAttrEntities().size(), false);
            }
        }
        if ("billType".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            baseTableName = "ejc_support_billtype";
            deleteBaseSql = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteBaseSql);
            if (vo.getBillTypeEntities() != null && vo.getBillTypeEntities().size() > 0) {
                this.billTypeService.saveOrUpdateBatch(vo.getBillTypeEntities(), vo.getBillTypeEntities().size(), false);
            }
        }
        if ("defdoc".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            baseTableName = "ejc_support_defdoc";
            String detailName = "ejc_support_defdoc_detail";
            String attrName = "ejc_support_defdoc_attribute";
            String attrSql = " delete from " + attrName + " where pid in " + idStr + ";";
            String detailSql = " delete from " + detailName + " where tenant_id = 999999 and defdoc_id in " + idStr + ";";
            String deleteBaseSql3 = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(attrSql);
            this.dataTransferMapper.executeSql(detailSql);
            this.dataTransferMapper.executeSql(deleteBaseSql3);
            if (vo.getDefdocEntities() != null && vo.getDefdocEntities().size() > 0) {
                this.defdocService.saveOrUpdateBatch(vo.getDefdocEntities(), vo.getDefdocEntities().size(), false);
            }
            if (vo.getDefdocDetailEntities() != null && vo.getDefdocDetailEntities().size() > 0) {
                this.defdocDetailService.saveOrUpdateBatch(vo.getDefdocDetailEntities(), vo.getDefdocDetailEntities().size(), false);
            }
            if (vo.getDefdocAttrEntites() != null && vo.getDefdocAttrEntites().size() > 0) {
                this.defdocAttrServiceImpl.saveOrUpdateBatch(vo.getDefdocAttrEntites(), vo.getDefdocAttrEntites().size(), false);
            }
        }
        if ("module".equals(vo.getType())) {
            idStr = "";
            idStr = "(" + vo.getModuleEntity().getId() + ")";
            baseTableName = "ejc_support_module";
            deleteBaseSql = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteBaseSql);
            if (vo.getModuleEntity() != null) {
                this.moduleService.saveOrUpdate((Object)vo.getModuleEntity(), false);
            }
        }
        if ("sysParam".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            baseTableName = "ejc_p_register";
            deleteBaseSql = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteBaseSql);
            if (vo.getParamRegisterEntities() != null && vo.getParamRegisterEntities().size() > 0) {
                this.paramRegisterService.saveOrUpdateBatch(vo.getParamRegisterEntities(), vo.getParamRegisterEntities().size(), false);
            }
        }
        if ("billParam".equals(vo.getType())) {
            idStr = "";
            for (Long id : vo.getIds()) {
                idStr = idStr + "'" + id + "',";
            }
            idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
            baseTableName = "ejc_bill_param";
            deleteBaseSql = " delete from " + (String)baseTableName + " where id in " + idStr + ";";
            this.dataTransferMapper.executeSql(deleteBaseSql);
            if (vo.getBillParamEntities() != null && vo.getBillParamEntities().size() > 0) {
                this.billParamService.saveOrUpdateBatch(vo.getBillParamEntities(), vo.getBillParamEntities().size(), false);
            }
        }
    }
}

