/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supsignature.signature.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.supsignature.signature.bean.AuthLogEntity;
import com.ejianc.business.supsignature.signature.service.IAuthLogService;
import com.ejianc.business.supsignature.signature.service.ISaasSignService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.qiyuesuo.sdk.v2.bean.Company;
import com.qiyuesuo.sdk.v2.bean.User;
import com.qiyuesuo.sdk.v2.response.SaaSCompanyAuthPageResult;
import com.qiyuesuo.sdk.v2.response.SaaSPrivilegeUrlResult;
import com.qiyuesuo.sdk.v2.response.SdkResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/saasSign"})
public class SaasSignController
implements Serializable {
    private static final long serialVersionUID = -4172061559099874029L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${qiyuesuoSaas.authCallbackUrl}")
    private String authCallbackUrl;
    @Autowired
    private ISaasSignService service;
    @Autowired
    private IAuthLogService authLogService;

    @PostMapping(value={"/queryCompanyDetail"})
    public CommonResponse<SdkResponse<Company>> queryCompanyDetail() {
        return this.service.queryCompanyDetail(((EnterpriseVO)this.service.getEnterpriseByTenantId().getData()).getFullName());
    }

    @PostMapping(value={"/queryCompanyAuthPage"})
    public CommonResponse<SdkResponse<SaaSCompanyAuthPageResult>> queryCompanyAuthPage() {
        CommonResponse<UserVO> user = this.service.getUserByUserId();
        HashMap<String, String> applicantInfo = new HashMap<String, String>();
        applicantInfo.put("name", ((UserVO)user.getData()).getUserName());
        applicantInfo.put("contact", ((UserVO)user.getData()).getUserMobile());
        applicantInfo.put("contactType", "MOBILE");
        return this.service.queryCompanyAuthPage(UserContext.getUserContext().getOrgName(), JSONObject.toJSONString(applicantInfo), null, null, null, this.authCallbackUrl);
    }

    @GetMapping(value={"/queryCompanyPrivilegeUrl"})
    public CommonResponse<SdkResponse<SaaSPrivilegeUrlResult>> queryCompanyPrivilegeUrl(@RequestParam(value="companyId") String companyId) {
        CommonResponse<UserVO> userVO = this.service.getUserByUserId();
        User user = new User();
        user.setContact(((UserVO)userVO.getData()).getUserMobile());
        user.setContactType("MOBILE");
        ArrayList<String> privilegeModules = new ArrayList<String>();
        privilegeModules.add("BASE_INFO");
        privilegeModules.add("SEAL");
        privilegeModules.add("CONTRACT");
        privilegeModules.add("COMPANY_EMPLOYEE");
        return this.service.queryCompanyPrivilegeUrl(Long.valueOf(companyId), null, user, false, null, null, privilegeModules);
    }

    @PostMapping(value={"/companyAuthCallback"})
    public void companyAuthCallback(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="content") String content) {
        this.logger.info("\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03,\u8fd4\u56de\u7684\u52a0\u5bc6\u53c2\u6570\uff1acontent--{}", (Object)content);
        String decrypt = this.service.decrypt(content, "\u4f01\u4e1a\u8ba4\u8bc1");
        this.logger.info("\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\uff1adecrypt--{}", (Object)decrypt);
        AuthLogEntity authLogEntity = (AuthLogEntity)((Object)JSONObject.parseObject((String)decrypt, AuthLogEntity.class));
        this.authLogService.saveOrUpdate((Object)authLogEntity, false);
        this.logger.info("\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\u683c\u5f0f\u5316\uff1aauthLogEntity--{}", (Object)JSONObject.toJSONString((Object)((Object)authLogEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    @PostMapping(value={"/companyPrivilegeCallback"})
    public void companyPrivilegeCallback(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="content") String content) {
        this.logger.info("\u4f01\u4e1a\u6388\u6743\u56de\u8c03,\u8fd4\u56de\u7684\u52a0\u5bc6\u53c2\u6570\uff1acontent--{}", (Object)content);
        String decrypt = this.service.decrypt(content, "\u4f01\u4e1a\u6388\u6743");
        this.logger.info("\u4f01\u4e1a\u6388\u6743\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\uff1adecrypt--{}", (Object)decrypt);
        this.logger.info("\u4f01\u4e1a\u6388\u6743\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\u683c\u5f0f\u5316\uff1adecrypt--{}", (Object)JSONObject.toJSONString((Object)decrypt, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    @PostMapping(value={"/contractStatusCallback"})
    public void contractStatusCallback(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="content") String content) {
        this.logger.info("\u5408\u540c\u72b6\u6001\u56de\u8c03,\u8fd4\u56de\u7684\u52a0\u5bc6\u53c2\u6570\uff1aencrypt--{}", (Object)content);
        String decrypt = this.service.decrypt(content, "\u5408\u540c\u72b6\u6001");
        this.logger.info("\u5408\u540c\u72b6\u6001\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\uff1adecrypt--{}", (Object)decrypt);
        this.logger.info("\u5408\u540c\u72b6\u6001\u56de\u8c03,\u89e3\u5bc6\u540e\u7684\u53c2\u6570\u683c\u5f0f\u5316\uff1adecrypt--{}", (Object)JSONObject.toJSONString((Object)decrypt, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    @GetMapping(value={"/ssoLoginUrl"})
    public CommonResponse<String> ssoLoginUrl(@RequestParam(value="companyId") String companyId, @RequestParam(value="saasClient") String saasClient) {
        return CommonResponse.success((String)"\u751f\u6210\u5355\u70b9\u767b\u5f55\u94fe\u63a5\uff0c\u6210\u529f\uff01", (Object)this.service.ssoLoginUrl(companyId, saasClient));
    }

    @PostMapping(value={"/casVerification"})
    public String casVerification(@RequestParam(value="ticket") String ticket) {
        this.logger.info("\u5951\u7ea6\u9501\u8bf7\u6c42CAS\u9a8c\u8bc1\u63a5\u53e3--------\u5165\u53c2\uff1a{}", (Object)ticket);
        String ticketDetail = this.service.casVerification(ticket);
        JSONObject ticketObject = JSONObject.parseObject((String)ticketDetail);
        this.logger.info("\u5151\u6362\u7684ticketDetail--------{}", (Object)ticketObject);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", ticketObject);
        map.put("code", 0);
        map.put("message", "SUCCESS");
        this.logger.info("\u5951\u7ea6\u9501\u8bf7\u6c42CAS\u9a8c\u8bc1\u63a5\u53e3--------\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return JSONObject.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
    }
}

