package com.ejianc.business.supsignature.signature.service;

import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.qiyuesuo.sdk.v2.bean.Company;
import com.qiyuesuo.sdk.v2.bean.User;
import com.qiyuesuo.sdk.v2.response.SaaSCompanyAuthPageResult;
import com.qiyuesuo.sdk.v2.response.SaaSPrivilegeUrlResult;
import com.qiyuesuo.sdk.v2.response.SdkResponse;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface ISaasSignService {


    /**
     * 数据解密
     *
     * @param encrypt 秘文
     * @return 明文
     */
    String decrypt(String encrypt, String sourceName);

    /**
     * 查询公司信息
     *
     * @param companyName 是 公司名称
     * @return 公司信息
     */
    CommonResponse<SdkResponse<Company>> queryCompanyDetail(String companyName);


    /**
     * 企业认证--获取企业认证链接
     *
     * @param companyName   是 待认证公司名称
     * @param applicantInfo 是 认证提交人信息（申请者姓名name， 联系方式contact，联系方式类型contactType：MOBILE、EMAIL），企业认证通过后，认证提交 人会自动成为该企业的系统管理员(例：{"name":"aaa","contact": "15100000000","contactType": "MOBILE"})
     * @param registerNo    否 待认证公司注册号
     * @param legalPerson   否 待认证公司法人姓名
     * @param license       否 营业执照
     * @param callbackUrl   否 认证回调地址
     * @return 企业认证链接
     */
    CommonResponse<SdkResponse<SaaSCompanyAuthPageResult>> queryCompanyAuthPage(String companyName,
                                                                String applicantInfo,
                                                                String registerNo,
                                                                String legalPerson,
                                                                MultipartFile license,
                                                                String callbackUrl);


    /**
     * 企业授权--获取授权链接
     *
     * @param companyId        是 企业Id
     * @param appId            否 平台Id，appId于【配置企业单点登录信息接口】回调时返回
     * @param user             是 操作人信息
     * @param createToken      否 是否生成token
     * @param successUrl       否 授权后跳转页面
     * @param callbackUrl      否 token生成后回调地址
     * @param privilegeModules 否 指定授权模块，指定的模块在授权页面默认勾选；可行值如下：SEAL（印章管理）、TEMPLATE（模板管理）、CONTRACT（合同管理）、COMPANY_EMPLOYEE（企业与成员）、（角色与权限）、BASE_INFO（基本信息）、FILE_STATISTICS（文件统计）、CATEGORY（业务分类）、FEE（费用中心）
     * @return 授权链接
     */
    CommonResponse<SdkResponse<SaaSPrivilegeUrlResult>> queryCompanyPrivilegeUrl(Long companyId,
                                                                 Long appId,
                                                                 User user,
                                                                 Boolean createToken,
                                                                 String successUrl,
                                                                 String callbackUrl,
                                                                 List<String> privilegeModules);


    /**
     * 单点登出
     * 请求域名：https://cloudapi.qiyuesuo.cn（测试环境）
     * https://cloudapi.qiyuesuo.com（正式环境）
     * 请求地址：/saas/ssologout
     * 请求方式：GET
     *
     * @return String
     */
    String ssoLogout();


    /**
     * CAS验证
     * 该接口用于验证SaaS调用单点登录接口时传入的ticket参数是否正确（是否由SaaS服务商提供并颁发），并将对应的ticket兑换为正确的登录用户信息。
     * 注意：为防重放攻击，请保证每一个ticket在经过该接口验证完成后，都会失效。
     * 请求方式：POST
     *
     * @param ticket 单点登录请求凭证，由SaaS服务商调用单点登录接口时传入
     * @return String 登录用户信息
     */
    String casVerification(String ticket);


    /**
     * 获取当前登录人信息
     *
     * @return UserVO
     */
    CommonResponse<UserVO> getUserByUserId();

    /**
     * 获取当前登录组织信息
     *
     * @return EnterpriseVO
     */
    CommonResponse<EnterpriseVO> getEnterpriseByTenantId();

    /**
     * 生成单点登录链接
     *
     * @return String url
     */
    String ssoLoginUrl(String companyId, String saasClient);
}
