/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supsignature.signature.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.supsignature.signature.service.ISaasSignService;
import com.ejianc.business.supsignature.signature.vo.TicketDetailVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.qiyuesuo.sdk.v2.SaaSSdkClient;
import com.qiyuesuo.sdk.v2.bean.Company;
import com.qiyuesuo.sdk.v2.bean.User;
import com.qiyuesuo.sdk.v2.http.FileItem;
import com.qiyuesuo.sdk.v2.http.StreamFile;
import com.qiyuesuo.sdk.v2.json.JSONUtils;
import com.qiyuesuo.sdk.v2.request.SaaSCompanyDetailRequest;
import com.qiyuesuo.sdk.v2.request.SaasCompanyAuthPageUrlRequest;
import com.qiyuesuo.sdk.v2.request.SaasPrivilegeUrlRequest;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.response.SaaSCompanyAuthPageResult;
import com.qiyuesuo.sdk.v2.response.SaaSPrivilegeUrlResult;
import com.qiyuesuo.sdk.v2.response.SdkResponse;
import com.qiyuesuo.sdk.v2.utils.CryptUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service(value="saasSignService")
public class ISaasSignServiceImpl
implements ISaasSignService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Value(value="${qiyuesuoSaas.ssoUrl}")
    private String ssoUrl;
    @Value(value="${qiyuesuoSaas.serverUrl}")
    private String serverUrl;
    @Value(value="${qiyuesuoSaas.agentToken}")
    private String agentToken;
    @Value(value="${qiyuesuoSaas.agentSecret}")
    private String agentSecret;
    @Value(value="${qiyuesuoSaas.secret}")
    private String secret;

    private SaaSSdkClient getSaasSdkClient() {
        return new SaaSSdkClient(this.agentToken, this.agentSecret, this.serverUrl);
    }

    @Override
    public String decrypt(String encrypt, String sourceName) {
        String result = null;
        try {
            result = CryptUtils.aesDerypt((String)encrypt, (String)this.secret);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("{}--\u56de\u8c03\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)sourceName, (Object)e.getMessage());
        }
        return result;
    }

    @Override
    public CommonResponse<SdkResponse<Company>> queryCompanyDetail(String companyName) {
        this.logger.info("\u5951\u7ea6\u9501------\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\uff0c\u5165\u53c2\uff1acompanyName--{}", (Object)companyName);
        SaaSSdkClient sdkClient = this.getSaasSdkClient();
        SaaSCompanyDetailRequest companyDetailRequest = new SaaSCompanyDetailRequest();
        if (StringUtils.isBlank((CharSequence)companyName)) {
            throw new BusinessException("\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\uff08\u516c\u53f8\u540d\u79f0\uff09\u4e3a\u7a7a\uff01");
        }
        companyDetailRequest.setCompanyName(companyName);
        String response = sdkClient.service((SdkRequest)companyDetailRequest);
        SdkResponse result = JSONUtils.toQysResponse((String)response, Company.class);
        if (result.getCode() != 0) {
            this.logger.info("\u67e5\u8be2\u516c\u53f8\uff08{}\uff09\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)companyName, (Object)result.getMessage());
        }
        this.logger.info("\u67e5\u8be2\u516c\u53f8\uff08{}\uff09\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)companyName, (Object)JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((Object)result);
    }

    @Override
    public CommonResponse<SdkResponse<SaaSCompanyAuthPageResult>> queryCompanyAuthPage(String companyName, String applicantInfo, String registerNo, String legalPerson, MultipartFile license, String callbackUrl) {
        String response;
        SdkResponse responseObject;
        this.logger.info("\u5951\u7ea6\u9501------\u4f01\u4e1a\u8ba4\u8bc1--\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\uff0c\u5165\u53c2\uff1acompanyName--{}\uff0capplicantInfo--{}\uff0ccallbackUrl--{}", new Object[]{companyName, applicantInfo, callbackUrl});
        SaaSSdkClient sdkClient = this.getSaasSdkClient();
        SaasCompanyAuthPageUrlRequest urlRequest = new SaasCompanyAuthPageUrlRequest();
        if (StringUtils.isBlank((CharSequence)companyName) || StringUtils.isBlank((CharSequence)applicantInfo)) {
            throw new BusinessException("\u4f01\u4e1a\u8ba4\u8bc1--\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\uff08\u5f85\u8ba4\u8bc1\u516c\u53f8\u540d\u79f0\u6216\u8ba4\u8bc1\u63d0\u4ea4\u4eba\u4fe1\u606f\uff09\u4e3a\u7a7a\uff01");
        }
        urlRequest.setCompanyName(companyName);
        urlRequest.setApplicantInfo(applicantInfo);
        if (StringUtils.isNotBlank((CharSequence)registerNo)) {
            urlRequest.setRegisterNo(registerNo);
        }
        if (StringUtils.isNotBlank((CharSequence)legalPerson)) {
            urlRequest.setLegalPerson(legalPerson);
        }
        if (license != null && !license.isEmpty()) {
            try {
                urlRequest.setLicense((FileItem)new StreamFile(license.getInputStream()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BusinessException("\u4f01\u4e1a\u8ba4\u8bc1--\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\uff08\u8425\u4e1a\u6267\u7167\uff09IO\u8bfb\u53d6\u5f02\u5e38\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            urlRequest.setCallbackUrl(callbackUrl);
        }
        if ((responseObject = JSONUtils.toQysResponse((String)(response = sdkClient.service((SdkRequest)urlRequest)), SaaSCompanyAuthPageResult.class)).getCode() != 0) {
            this.logger.info("\u4f01\u4e1a\u8ba4\u8bc1--\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseObject.getMessage());
        }
        this.logger.info("\u4f01\u4e1a\u8ba4\u8bc1--\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)responseObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((Object)responseObject);
    }

    @Override
    public CommonResponse<SdkResponse<SaaSPrivilegeUrlResult>> queryCompanyPrivilegeUrl(Long companyId, Long appId, User user, Boolean createToken, String successUrl, String callbackUrl, List<String> privilegeModules) {
        String response;
        SdkResponse responseObject;
        this.logger.info("\u5951\u7ea6\u9501------\u4f01\u4e1a\u6388\u6743--\u83b7\u53d6\u6388\u6743\u94fe\u63a5\uff0c\u5165\u53c2\uff1acompanyId--{}\uff0cappId--{}\uff0cuser--{}\uff0ccreateToken--{}\uff0csuccessUrl--{}\uff0ccallbackUrl--{}\uff0cprivilegeModules--{}", new Object[]{companyId, appId, JSONObject.toJSONString((Object)user, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), createToken, successUrl, callbackUrl, JSONObject.toJSONString(privilegeModules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        SaaSSdkClient sdkClient = this.getSaasSdkClient();
        SaasPrivilegeUrlRequest urlRequest = new SaasPrivilegeUrlRequest();
        if (companyId == null || user == null) {
            throw new BusinessException("\u4f01\u4e1a\u6388\u6743--\u83b7\u53d6\u6388\u6743\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\uff08\u4f01\u4e1aId\u6216\u64cd\u4f5c\u4eba\u4fe1\u606f\uff09\u4e3a\u7a7a\uff01");
        }
        urlRequest.setCompanyId(companyId);
        urlRequest.setUser(user);
        if (appId != null) {
            urlRequest.setAppId(appId);
        }
        if (createToken != null) {
            urlRequest.setCreateToken(createToken);
        }
        if (StringUtils.isNotBlank((CharSequence)successUrl)) {
            urlRequest.setSuccessUrl(successUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            urlRequest.setCallbackUrl(callbackUrl);
        }
        if (!privilegeModules.isEmpty()) {
            urlRequest.setPrivilegeModules(privilegeModules);
        }
        if ((responseObject = JSONUtils.toQysResponse((String)(response = sdkClient.service((SdkRequest)urlRequest)), SaaSPrivilegeUrlResult.class)).getCode() != 0) {
            this.logger.info("\u4f01\u4e1a\u6388\u6743--\u83b7\u53d6\u6388\u6743\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseObject.getMessage());
        }
        this.logger.info("\u4f01\u4e1a\u6388\u6743--\u83b7\u53d6\u6388\u6743\u94fe\u63a5\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)responseObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((Object)responseObject);
    }

    @Override
    public String ssoLogout() {
        String ssoLogoutUrl = this.ssoUrl + "/saas/ssogateway";
        return HttpUtil.get((String)ssoLogoutUrl, (int)5);
    }

    @Override
    public String casVerification(String ticket) {
        Boolean delFlag;
        this.logger.info("\u5951\u7ea6\u9501------CAS\u9a8c\u8bc1--\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff0c\u5165\u53c2\uff1aticket--{}", (Object)ticket);
        String ticketDetail = this.jedisTemplate.get(ticket);
        if (StringUtils.isBlank((CharSequence)ticketDetail)) {
            this.logger.info("\u5f53\u524d\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u51ed\u8bc1--ticket\uff1a{}\uff0c\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01", (Object)ticket);
        }
        if (!(delFlag = this.jedisTemplate.del(new String[]{ticket})).booleanValue()) {
            this.logger.info("\u5f53\u524d\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u51ed\u8bc1--ticket\uff1a{}\uff0c\u5220\u9664\u5931\u8d25\uff01", (Object)ticket);
        }
        return ticketDetail;
    }

    @Override
    public CommonResponse<UserVO> getUserByUserId() {
        CommonResponse user = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!user.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u7528\u6237\uff08{}\uff09\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)InvocationInfoProxy.getUserid(), (Object)user.getMsg());
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + user.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)((UserVO)user.getData()).getUserName()) || StringUtils.isBlank((CharSequence)((UserVO)user.getData()).getUserMobile())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\uff08" + InvocationInfoProxy.getUserid() + "\uff09\u59d3\u540d\u6216\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\u540e\u518d\u8bd5\uff01");
        }
        return user;
    }

    @Override
    public CommonResponse<EnterpriseVO> getEnterpriseByTenantId() {
        CommonResponse resp = this.enterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)InvocationInfoProxy.getTenantid(), (Object)JSONObject.toJSONString((Object)resp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!resp.isSuccess() || StringUtils.isBlank((CharSequence)((EnterpriseVO)resp.getData()).getFullName())) {
            throw new BusinessException("\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u516c\u53f8\u540d\u79f0!");
        }
        return resp;
    }

    @Override
    public String ssoLoginUrl(String companyId, String saasClient) {
        String uuid = IdUtil.simpleUUID();
        CommonResponse<UserVO> user = this.getUserByUserId();
        TicketDetailVO ticketDetail = new TicketDetailVO();
        ticketDetail.setName(((UserVO)user.getData()).getUserName());
        ticketDetail.setContact(((UserVO)user.getData()).getUserMobile());
        this.jedisTemplate.set(uuid, JSONObject.toJSONString((Object)ticketDetail));
        return this.ssoUrl + "/saas/ssogateway?ticket=" + uuid + "&pageType=CONTRACT_LIST_PAGE&companyId=" + companyId + "&hideSidebar=true&saasClient=" + saasClient;
    }
}

