package com.ejianc.business.targetcost.api;

import com.ejianc.business.targetcost.hystrix.TargetCostFinishHystrix;
import com.ejianc.business.targetcost.vo.CostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 执行情况rpc服务
 *
 *
 */
@FeignClient(name= "ejc-targetcost-web", url="${common.env.feign-client-url}", path="ejc-targetcost-web", fallback = TargetCostFinishHystrix.class)
public interface ITargetCostFinishApi {

	/**
	 * costReportQueryNew 成本报表查询完工情况
	 *
	 */
	@GetMapping(value = "/api/finish/costReportQueryNew")
	CommonResponse<List<CostReportVO>> costReportQueryNew(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "endDate", required = false) String endDate, @RequestParam(value = "beginPeriod", required = false) String beginPeriod);


	/**
	 * costReportQuery 成本报表查询完工情况
	 *
	 */
	@GetMapping(value = "/api/finish/costReportQuery")
	CommonResponse<List<CostReportVO>> costReportQuery(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "endDate", required = false) String endDate, @RequestParam(value = "beginPeriod", required = false) String beginPeriod);


}
