package com.ejianc.business.zhht.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 项目季度成本分析 
 * 
 * @author generator
 * 
 */
public class ProjectSeasonAnalyseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String constructName; // 建设单位
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private String billCode; // 单据编码
    private String projectArea; // 工程规模
    private BigDecimal contractMny; // 合同总金额
    private String memo; // 成本分析情况总结
    private Integer billState; // 审批状态
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String projectCode; // 项目编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 成本分析开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 成本分析结束日期
    private BigDecimal sumProductMny; // 实际完成产值  累计产值金额
    private BigDecimal sumReplyMny; // 业主批复产值
    private BigDecimal planCostMny; // 策划成本金额
    private BigDecimal actualCostMny; // 实际成本金额
    private BigDecimal sumProductActualSub; // 累计(产值-实际成本)
    private BigDecimal sumReceiveMny; // 累计收款金额
    private BigDecimal sumPayMny; // 累计付款金额
    private BigDecimal sumReceivePaySub; // 累计(收款-付款)
    private Long constructId; // 建设单位id

    @ReferSerialTransfer(referCode="share-pro-customer")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectArea() {
        return projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getSumProductMny() {
        return sumProductMny;
    }

    public void setSumProductMny(BigDecimal sumProductMny) {
        this.sumProductMny = sumProductMny;
    }
    public BigDecimal getSumReplyMny() {
        return sumReplyMny;
    }

    public void setSumReplyMny(BigDecimal sumReplyMny) {
        this.sumReplyMny = sumReplyMny;
    }
    public BigDecimal getPlanCostMny() {
        return planCostMny;
    }

    public void setPlanCostMny(BigDecimal planCostMny) {
        this.planCostMny = planCostMny;
    }
    public BigDecimal getActualCostMny() {
        return actualCostMny;
    }

    public void setActualCostMny(BigDecimal actualCostMny) {
        this.actualCostMny = actualCostMny;
    }

    public BigDecimal getSumProductActualSub() {
        return sumProductActualSub;
    }

    public void setSumProductActualSub(BigDecimal sumProductActualSub) {
        this.sumProductActualSub = sumProductActualSub;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumReceivePaySub() {
        return sumReceivePaySub;
    }

    public void setSumReceivePaySub(BigDecimal sumReceivePaySub) {
        this.sumReceivePaySub = sumReceivePaySub;
    }
    
}
