package com.ejianc.business.costinspection.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本巡检现场跟踪表
 * 
 * @author generator
 * 
 */
public class SiteTrackingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String billCode; // 单据编码
    private Integer billState; // 审批状态
    private String memo; // 备注
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date inspectionTime; // 巡检时间
    private Long projectLeaderId; // 项目负责人
    private String projectLeader; // 项目负责人名称
    private Long costCommunicatId; // 项目成本对接人
    private String costCommunicatName; // 项目成本对接人名称
    private Long inspectionPersonId; // 成本巡检人员
    private String inspectionPersonName; // 成本巡检人员名称
    private String participant; // 项目参与人员
    private String isRectificationForm; // 是否下发整改单
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date rectificationTime; // 限时整改日期
    private Long noticeId;//notice_id
    private Long reportId;//report_id
    private String code;//code
    private String gzFileUrl;//
    private String gzFileName;//
    private String zgFileUrl;//
    private String zgFileName;//
    private String hfFileUrl;//
    private String hfFileName;//
    private String bgFileUrl;//
    private String bgFileName;//
    private String isInspection; // 项目参与人员

    private List<SiteTrackingContentVO> siteTrackingContentList = new ArrayList<>(); // 巡检跟踪子表

    private List<SiteTrackingRectifyContentVO> siteTrackingRectifyContentList = new ArrayList<>(); // 巡检跟踪整改子表

    public List<SiteTrackingRectifyContentVO> getSiteTrackingRectifyContentList() {
        return siteTrackingRectifyContentList;
    }

    public void setSiteTrackingRectifyContentList(List<SiteTrackingRectifyContentVO> siteTrackingRectifyContentList) {
        this.siteTrackingRectifyContentList = siteTrackingRectifyContentList;
    }

    public String getIsInspection() {
        return isInspection;
    }

    public void setIsInspection(String isInspection) {
        this.isInspection = isInspection;
    }

    public List<SiteTrackingContentVO> getSiteTrackingContentList() {
        return siteTrackingContentList;
    }

    public void setSiteTrackingContentList(List<SiteTrackingContentVO> siteTrackingContentList) {
        this.siteTrackingContentList = siteTrackingContentList;
    }

    public String getGzFileUrl() {
        return gzFileUrl;
    }

    public void setGzFileUrl(String gzFileUrl) {
        this.gzFileUrl = gzFileUrl;
    }

    public String getGzFileName() {
        return gzFileName;
    }

    public void setGzFileName(String gzFileName) {
        this.gzFileName = gzFileName;
    }

    public String getZgFileUrl() {
        return zgFileUrl;
    }

    public void setZgFileUrl(String zgFileUrl) {
        this.zgFileUrl = zgFileUrl;
    }

    public String getZgFileName() {
        return zgFileName;
    }

    public void setZgFileName(String zgFileName) {
        this.zgFileName = zgFileName;
    }

    public String getHfFileUrl() {
        return hfFileUrl;
    }

    public void setHfFileUrl(String hfFileUrl) {
        this.hfFileUrl = hfFileUrl;
    }

    public String getHfFileName() {
        return hfFileName;
    }

    public void setHfFileName(String hfFileName) {
        this.hfFileName = hfFileName;
    }

    public String getBgFileUrl() {
        return bgFileUrl;
    }

    public void setBgFileUrl(String bgFileUrl) {
        this.bgFileUrl = bgFileUrl;
    }

    public String getBgFileName() {
        return bgFileName;
    }

    public void setBgFileName(String bgFileName) {
        this.bgFileName = bgFileName;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public Long getReportId() {
        return reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIsRectificationForm() {
        return isRectificationForm;
    }

    public void setIsRectificationForm(String isRectificationForm) {
        this.isRectificationForm = isRectificationForm;
    }

    public Date getRectificationTime() {
        return rectificationTime;
    }

    public void setRectificationTime(Date rectificationTime) {
        this.rectificationTime = rectificationTime;
    }


    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }
    @ReferDeserialTransfer
    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }

    public String getProjectLeader() {
        return projectLeader;
    }

    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getCostCommunicatId() {
        return costCommunicatId;
    }
    @ReferDeserialTransfer
    public void setCostCommunicatId(Long costCommunicatId) {
        this.costCommunicatId = costCommunicatId;
    }


    public String getCostCommunicatName() {
        return costCommunicatName;
    }

    public void setCostCommunicatName(String costCommunicatName) {
        this.costCommunicatName = costCommunicatName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getInspectionPersonId() {
        return inspectionPersonId;
    }
    @ReferDeserialTransfer
    public void setInspectionPersonId(Long inspectionPersonId) {
        this.inspectionPersonId = inspectionPersonId;
    }

    public String getInspectionPersonName() {
        return inspectionPersonName;
    }

    public void setInspectionPersonName(String inspectionPersonName) {
        this.inspectionPersonName = inspectionPersonName;
    }
    public String getParticipant() {
        return participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }
    
}
