package com.ejianc.business.targetcost.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;


/**
 * 目标成本总金额执行情况
 *
 * @author generator
 *
 */
public class TotalExecutionVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    @NotNull(message = "所属组织不能为空")
    private Long orgId; // 所属组织
    @NotNull(message = "项目不能为空")
    private Long projectId; // 项目ID
    @NotBlank(message = "单据分类不能为空")
    private Integer billCategory; // 单据分类：1.计划2.合同3.入库4.其他
    @NotBlank(message = "单据类型不能为空")
    private String billType; // 单据类型
    @NotBlank(message = "业务类型不能为空")
    private String bussinessType; // 业务类型
    private String property; // 属性
    private BigDecimal money; // 金额(无税)
    private BigDecimal taxMoney; // 金额
    private String memo; // 备注
    private String billDate; // 业务日期
    private String linkUrl; // 联查url
    @NotNull(message = "来源主键不能为空")
    private Long sourceId; // 来源ID
    private Long lastSourceId;// 如果是变更单，就为上一版本主表主键，且必传


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Integer getBillCategory() {
        return billCategory;
    }

    public void setBillCategory(Integer billCategory) {
        this.billCategory = billCategory;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
    public String getBussinessType() {
        return bussinessType;
    }

    public void setBussinessType(String bussinessType) {
        this.bussinessType = bussinessType;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBillDate() {
        return billDate;
    }

    public void setBillDate(String billDate) {
        this.billDate = billDate;
    }
    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Long getLastSourceId() {
        return lastSourceId;
    }

    public void setLastSourceId(Long lastSourceId) {
        this.lastSourceId = lastSourceId;
    }
}
