package com.ejianc.business.costcheck.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.costcheck.vo.ProjectCheckDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目检查表
 * 
 * @author generator
 * 
 */
public class ProjectCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long personCheckId; // 检查人ID
    private String personCheckName; // 检查人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查时间
    private String projectState; // 项目状态
    private BigDecimal contractMny; // 合同金额
    private BigDecimal buildingCost; // 工程造价金额
    private BigDecimal controlMny; // 管控金额
    private String gradeStaff; // 评定等级主管
    private String gradeLeader; // 评定等级经理
    private String remark; // 备注
    private Long majorProjectId; // 项目ID
    private Integer cite; // 是否被引用 1true 0false
    private String problemDescriptionStaff; // 项目问题描述主管
    private String lastProblemDescription; // 上次项目问题描述
    private String lastGrade; // 上次评定等级
    private Long lastProjectCheckId; // 上次检查单id
    private String problemDescriptionLeader; // 项目问题描述经理
    private List<ProjectCheckDetailVO> projectCheckDetailList = new ArrayList<>(); // 项目检查明细
    private String cTypeProblem; //C类项目项目定性


    private String cTypeProblemIds; //C类项目项目定性

    public String getcTypeProblem() {
        return cTypeProblem;
    }

    public void setcTypeProblem(String cTypeProblem) {
        this.cTypeProblem = cTypeProblem;
    }

    public String getcTypeProblemIds() {
        return cTypeProblemIds;
    }

    public void setcTypeProblemIds(String cTypeProblemIds) {
        this.cTypeProblemIds = cTypeProblemIds;
    }

    public String getProblemDescriptionStaff() {
        return problemDescriptionStaff;
    }

    public void setProblemDescriptionStaff(String problemDescriptionStaff) {
        this.problemDescriptionStaff = problemDescriptionStaff;
    }

    public String getLastProblemDescription() {
        return lastProblemDescription;
    }

    public void setLastProblemDescription(String lastProblemDescription) {
        this.lastProblemDescription = lastProblemDescription;
    }

    public String getLastGrade() {
        return lastGrade;
    }

    public void setLastGrade(String lastGrade) {
        this.lastGrade = lastGrade;
    }

    public Long getLastProjectCheckId() {
        return lastProjectCheckId;
    }

    public void setLastProjectCheckId(Long lastProjectCheckId) {
        this.lastProjectCheckId = lastProjectCheckId;
    }

    public String getProblemDescriptionLeader() {
        return problemDescriptionLeader;
    }

    public void setProblemDescriptionLeader(String problemDescriptionLeader) {
        this.problemDescriptionLeader = problemDescriptionLeader;
    }

    public Integer getCite() {
        return cite;
    }

    public void setCite(Integer cite) {
        this.cite = cite;
    }

    public Long getMajorProjectId() {
        return majorProjectId;
    }
    @ReferDeserialTransfer
    public void setMajorProjectId(Long majorProjectId) {
        this.majorProjectId = majorProjectId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getPersonCheckId() {
        return personCheckId;
    }
    @ReferDeserialTransfer
    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getProjectState() {
        return projectState;
    }

    public void setProjectState(String projectState) {
        this.projectState = projectState;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getBuildingCost() {
        return buildingCost;
    }

    public void setBuildingCost(BigDecimal buildingCost) {
        this.buildingCost = buildingCost;
    }
    public BigDecimal getControlMny() {
        return controlMny;
    }

    public void setControlMny(BigDecimal controlMny) {
        this.controlMny = controlMny;
    }
    public String getGradeStaff() {
        return gradeStaff;
    }

    public void setGradeStaff(String gradeStaff) {
        this.gradeStaff = gradeStaff;
    }
    public String getGradeLeader() {
        return gradeLeader;
    }

    public void setGradeLeader(String gradeLeader) {
        this.gradeLeader = gradeLeader;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
     public List<ProjectCheckDetailVO> getProjectCheckDetailList() {
        return projectCheckDetailList;
     }

     public void setProjectCheckDetailList(List<ProjectCheckDetailVO> projectCheckDetailList) {
        this.projectCheckDetailList = projectCheckDetailList;
     }
}
