package com.ejianc.business.targetcost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 目标成本节点分析线下提交
 * 
 * @author generator
 * 
 */
public class DutyAssessRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String remark; // 备注
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String assessType; // 本次分析类型
    private Long assessId; // 节点ID
    private String assessName; // 节点名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 分析提交日期
    private BigDecimal srcztj; // 收入产值统计(无税)
    private BigDecimal sjcbtj; // 实际成本统计(无税)
    private BigDecimal ykje; // 盈亏金额(收入-实际)
    private BigDecimal ykl; // 盈亏率(收入-实际)/实际
    private String memo; // 成本分析说明
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getAssessType() {
        return assessType;
    }

    public void setAssessType(String assessType) {
        this.assessType = assessType;
    }
    public Long getAssessId() {
        return assessId;
    }
    @ReferDeserialTransfer
    public void setAssessId(Long assessId) {
        this.assessId = assessId;
    }
    public String getAssessName() {
        return assessName;
    }

    public void setAssessName(String assessName) {
        this.assessName = assessName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public BigDecimal getSrcztj() {
        return srcztj;
    }

    public void setSrcztj(BigDecimal srcztj) {
        this.srcztj = srcztj;
    }
    public BigDecimal getSjcbtj() {
        return sjcbtj;
    }

    public void setSjcbtj(BigDecimal sjcbtj) {
        this.sjcbtj = sjcbtj;
    }
    public BigDecimal getYkje() {
        return ykje;
    }

    public void setYkje(BigDecimal ykje) {
        this.ykje = ykje;
    }
    public BigDecimal getYkl() {
        return ykl;
    }

    public void setYkl(BigDecimal ykl) {
        this.ykl = ykl;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
