package com.ejianc.business.costcheck.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本检查记录
 * 
 * @author generator
 * 
 */
public class RecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String remark; // 备注
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long personCheckId; // 检查人ID
    private String personCheckName; // 检查人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查时间
    private Long checkItemId; // 检查项ID
    private String checkItemName; // 检查项名称
    private String checkItemCode; // 检查项编号
    private String problemDescription; // 问题描述
    private Long sourceBillId; // 单据的id
    private String sourceBillCode; // 单据的编号
    private String sourceBillUrl; // 单据的地址
    private Integer cite; // 是否被引用 1true 0false
    private Long majorProjectId; // 项目ID
    private String majorItem; //
    private List<RecordDetailVO> recordDetailList = new ArrayList<>(); // 成本检查记录明细


    public List<RecordDetailVO> getRecordDetailList() {
        return recordDetailList;
    }

    public void setRecordDetailList(List<RecordDetailVO> recordDetailList) {
        this.recordDetailList = recordDetailList;
    }

    public String getMajorItem() {
        return majorItem;
    }

    public void setMajorItem(String majorItem) {
        this.majorItem = majorItem;
    }

    public Long getMajorProjectId() {
        return majorProjectId;
    }
    @ReferDeserialTransfer
    public void setMajorProjectId(Long majorProjectId) {
        this.majorProjectId = majorProjectId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    @ReferSerialTransfer(referCode = "idm-user")
    public Long getPersonCheckId() {
        return personCheckId;
    }
    @ReferDeserialTransfer
    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    @ReferSerialTransfer(referCode = "refItemDetailData")
    public Long getCheckItemId() {
        return checkItemId;
    }
    @ReferDeserialTransfer
    public void setCheckItemId(Long checkItemId) {
        this.checkItemId = checkItemId;
    }
    public String getCheckItemName() {
        return checkItemName;
    }

    public void setCheckItemName(String checkItemName) {
        this.checkItemName = checkItemName;
    }
    public String getCheckItemCode() {
        return checkItemCode;
    }

    public void setCheckItemCode(String checkItemCode) {
        this.checkItemCode = checkItemCode;
    }
    public String getProblemDescription() {
        return problemDescription;
    }

    public void setProblemDescription(String problemDescription) {
        this.problemDescription = problemDescription;
    }
    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public String getSourceBillUrl() {
        return sourceBillUrl;
    }

    public void setSourceBillUrl(String sourceBillUrl) {
        this.sourceBillUrl = sourceBillUrl;
    }
    public Integer getCite() {
        return cite;
    }

    public void setCite(Integer cite) {
        this.cite = cite;
    }
    
}
