package com.ejianc.business.costplan.api;

import com.ejianc.business.costplan.hystrix.CostPlanHystrix;
import com.ejianc.business.targetcost.hystrix.TargetCostFinishHystrix;
import com.ejianc.business.targetcost.vo.CostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 执行情况rpc服务
 *
 *
 */
@FeignClient(name= "ejc-targetcost-web", url="${common.env.feign-client-url}", path="ejc-targetcost-web", fallback = CostPlanHystrix.class)
public interface ICostPlanApi {

	/**
	 * 修改成本分析节点计划完成状态
	 *
	 */
	@GetMapping(value = "/dutyAssessPlan/api/updateFinishState")
	CommonResponse<String> updateFinishState(@RequestParam(value = "assessId") Long assessId,
											 @RequestParam(value = "reportId") Long reportId,
											 @RequestParam(value = "isFinish") Integer isFinish );
	/**
	 * 修改成本关门节点计划完成状态
	 *
	 */
	@GetMapping(value = "/costClosePlan/api/updateFinishStateCostClose")
	CommonResponse<String> updateFinishStateCostClose(@RequestParam(value = "projectId") Long projectId,
													  @RequestParam(value = "coseCloseId") Long coseCloseId,
													  @RequestParam(value = "isFinish") Integer isFinish);


}
