package com.ejianc.business.targetcost.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.targetcost.hystrix.ExecutionHystrix;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 执行情况rpc服务
 *
 *
 */
@FeignClient(name= "ejc-targetcost-web", url="${common.env.feign-client-url}", path="ejc-targetcost-web", fallback = ExecutionHystrix.class)
public interface IExecutionApi {

	/**
	 * 推送
	 *
	 * @param executionVO
	 * @return
	 */
	@PostMapping(value = "/api/execution/aggPush")
	CommonResponse<String> aggPush(@RequestBody ExecutionVO executionVO);


	/**
	 * 删除
	 *
	 * @param totalExecutionVOList
	 * @return
	 */
	@PostMapping(value = "/api/execution/aggDel")
	CommonResponse<String> aggDel(@RequestBody List<TotalExecutionVO> totalExecutionVOList);

	/**
	 * 控制
	 *
	 * @param executionVO
	 * @return
	 */
	@PostMapping(value = "/api/execution/ctrlJson")
	CommonResponse<JSONObject> ctrlJson(@RequestBody ExecutionVO executionVO);

	/**
	 * 控制
	 *
	 * @param executionVO
	 * @return
	 */
	@PostMapping(value = "/api/execution/ctrlCheckVO")
	CommonResponse<ParamsCheckVO> ctrlCheckVO(@RequestBody ExecutionVO executionVO);

	/**
	 * 获取项目的合同总额
	 *
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "/api/execution/queryTotalContMny")
	CommonResponse<BigDecimal>  queryTotalContMny(@RequestParam(value = "projectId") Long projectId);

}
