/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="duty")
public class DutyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private ITotalExecutionService totalExecutionService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u63d0\u4ea4\u524d\u56de\u8c03====================================== state:" + state);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(DutyDetailItemEntity::getDutyId, (Object)billId);
        List dutyDetailItemEntityList = this.dutyDetailItemService.list((Wrapper)query);
        for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList) {
            if (dutyDetailItemEntity.getTaxRate() == null) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u7a0e\u7387\u5fc5\u586b\uff01 ");
            }
            if (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u6570\u91cf\u5fc5\u586b\uff01");
            }
            if (dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011\uff0c\u5355\u4ef7(\u65e0\u7a0e)\u5fc5\u586b\uff01");
            }
            if (dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4ef7\u5fc5\u586b\uff01");
            }
            if (dutyDetailItemEntity.getUnitName() != null) continue;
            throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4f4d\u5fc5\u586b\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.logger.info("state---------------\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03-------------------" + state);
        if (state == 0 && dutyEntity.getLastDutyId() == null && (BooleanUtils.isFalse((Boolean)dutyEntity.getLatestFlag()) || 1 != dutyEntity.getDutyVersion() && BooleanUtils.isFalse((Boolean)dutyEntity.getEnableState()))) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03====================================== state:" + state);
        if (state == 0) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(DutyDetailItemEntity::getDutyId, (Object)billId);
            List dutyDetailItemEntityList = this.dutyDetailItemService.list((Wrapper)query);
            for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList) {
                if (dutyDetailItemEntity.getTaxRate() == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u7a0e\u7387\u5fc5\u586b\uff01 ");
                }
                if (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u6570\u91cf\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011\uff0c\u5355\u4ef7(\u65e0\u7a0e)\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4ef7\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getUnitName() != null) continue;
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4f4d\u5fc5\u586b\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, true);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("state---------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03-------------------" + state);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        if (!dutyEntity.getEnableState().booleanValue() || !dutyEntity.getLatestFlag().booleanValue()) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    private void updateEnableAndWriteBack(Long billId, Boolean isPass) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getById(billId));
        dutyEntity.setEnableState(isPass);
        this.dutyService.saveOrUpdate((Object)dutyEntity);
        if (dutyEntity.getLastDutyId() != null) {
            DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(dutyEntity.getLastDutyId()));
            revise.setChangeState(isPass != false ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setEnableState(isPass == false);
            this.dutyService.saveOrUpdate((Object)revise);
        }
    }
}

