/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.FeeTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class TargetcostWarnCallable
implements Callable<CommonResponse<String>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TC_LOCK = "TC_LOCK::";
    private static final String PC_URL = "/ejc-targetcost-frontend/#/execution?";
    private static final String WARN_ID = "584793299912114241";
    private static final String WARN_PARAM_ID = "584793299912114241";
    private String authority;
    private RequestAttributes context;
    private IWarnCenterApi warnCenterApi;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private List<DutyEntity> dutyEntities;
    private IRuleService ruleService;
    private IRuleDetailService ruleDetailService;
    private IRuleReceiverService ruleReceiverService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;

    public TargetcostWarnCallable(String authority, RequestAttributes context, IWarnCenterApi warnCenterApi, RedissonClient redissonClient, ITotalCacheService totalCacheService, IDetailCacheService detailCacheService, List<DutyEntity> dutyEntities, IRuleService ruleService, IRuleDetailService ruleDetailService, IRuleReceiverService ruleReceiverService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService) {
        this.authority = authority;
        this.context = context;
        this.warnCenterApi = warnCenterApi;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyEntities = dutyEntities;
        this.ruleService = ruleService;
        this.ruleDetailService = ruleDetailService;
        this.ruleReceiverService = ruleReceiverService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> call() throws Exception {
        this.context.setAttribute("authority", (Object)this.authority, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        for (DutyEntity dutyEntity : this.dutyEntities) {
            CommonResponse warnResp;
            block18: {
                String lockKey = TC_LOCK + dutyEntity.getProjectId();
                RLock mylock = this.redissonClient.getLock(lockKey);
                try {
                    boolean lock = mylock.tryLock(20L, TimeUnit.SECONDS);
                    if (!lock) {
                        this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25 is " + dutyEntity.getProjectId());
                        CommonResponse commonResponse = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + dutyEntity.getProjectId()));
                        return commonResponse;
                    }
                    List<OrgVO> orgVOList = dutyEntity.getOrgList();
                    HashSet<Long> ruleIdSet = new HashSet<Long>();
                    List ruleEntities = null;
                    HashMap<Long, RuleEntity> ruleMap = new HashMap<Long, RuleEntity>();
                    if (CollectionUtils.isNotEmpty(orgVOList)) {
                        List orgList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(RuleEntity::getFeeId, (Object)dutyEntity.getFeeId());
                        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
                        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                        queryWrapper.in(RuleEntity::getBillState, billStatusList);
                        queryWrapper.in(RuleEntity::getOrgId, orgList);
                        ruleEntities = this.ruleService.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isNotEmpty((Collection)ruleEntities)) {
                            for (RuleEntity ruleEntity : ruleEntities) {
                                ruleIdSet.add(ruleEntity.getId());
                                ruleMap.put(ruleEntity.getId(), ruleEntity);
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(ruleIdSet)) {
                        this.logger.error("\u8be5\u8d23\u4efb\u6210\u672c\u6ca1\u6709\u63a7\u5236\u89c4\u5219\uff1a" + JSONObject.toJSONString((Object)((Object)dutyEntity)));
                        continue;
                    }
                    LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
                    scopeQuery.eq(FeeDetailScopeEntity::getFeeId, (Object)dutyEntity.getFeeId());
                    List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
                    HashMap<String, String> scopeMap = new HashMap<String, String>();
                    if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
                        for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                            scopeMap.put(scopeEntity.getBillCode(), scopeEntity.getMemoValue());
                        }
                    }
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(DetailCacheEntity::getProjectId, (Object)dutyEntity.getProjectId());
                    List detailCacheEntities = this.detailCacheService.list((Wrapper)queryWrapper);
                    LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
                    queryWrapper1.eq(TotalCacheEntity::getProjectId, (Object)dutyEntity.getProjectId());
                    List totalCacheEntities = this.totalCacheService.list((Wrapper)queryWrapper1);
                    List feeDetailPks = totalCacheEntities.stream().map(TotalCacheEntity::getFeeDetailId).collect(Collectors.toList());
                    HashMap<String, List<RuleDetailEntity>> ruleDetailMap = new HashMap<String, List<RuleDetailEntity>>();
                    ArrayList<Long> ruleDetailList = new ArrayList<Long>();
                    LambdaQueryWrapper ruleDetailQuery = new LambdaQueryWrapper();
                    ruleDetailQuery.in(RuleDetailEntity::getControlType, new Object[]{ControlTypeEnum.\u98ce\u9669\u9884\u8b66.getCode()});
                    ruleDetailQuery.in(RuleDetailEntity::getRuleId, ruleIdSet);
                    ruleDetailQuery.in(RuleDetailEntity::getFeeDetailId, feeDetailPks);
                    List ruleDetailEntities = this.ruleDetailService.list((Wrapper)ruleDetailQuery);
                    for (RuleDetailEntity entity : ruleDetailEntities) {
                        String key = entity.getFeeInnerCode();
                        List list = ruleDetailMap.containsKey(key) ? (List)ruleDetailMap.get(key) : new ArrayList();
                        list.add(entity);
                        ruleDetailMap.put(key, list);
                        ruleDetailList.add(entity.getId());
                    }
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.in(RuleReceiverEntity::getRuleDetailId, ruleDetailList);
                    List receiverEntities = this.ruleReceiverService.list((Wrapper)query);
                    HashMap<Long, List<RuleReceiverEntity>> receiverMap = new HashMap<Long, List<RuleReceiverEntity>>();
                    if (CollectionUtils.isNotEmpty((Collection)receiverEntities)) {
                        for (RuleReceiverEntity receiverEntity : receiverEntities) {
                            List<RuleReceiverEntity> list = null;
                            list = receiverMap.containsKey(receiverEntity.getRuleDetailId()) ? (List)receiverMap.get(receiverEntity.getRuleDetailId()) : new ArrayList<RuleReceiverEntity>();
                            list.add(receiverEntity);
                            receiverMap.put(receiverEntity.getRuleDetailId(), list);
                        }
                    }
                    List<EarlyWarnTransVO> warnTransVOS = this.ctrl(detailCacheEntities, totalCacheEntities, ruleMap, ruleDetailMap, dutyEntity, receiverMap, scopeMap);
                    this.logger.error("warnTransVOS is " + JSONObject.toJSONString(warnTransVOS));
                    if (!CollectionUtils.isNotEmpty(warnTransVOS)) break block18;
                    warnList.addAll(warnTransVOS);
                }
                catch (Exception e) {
                    this.logger.error("\u76ee\u6807\u6210\u672c\u9884\u8b66\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
                }
                finally {
                    mylock.unlock();
                    continue;
                }
            }
            if (!CollectionUtils.isNotEmpty(warnList) || (warnResp = this.warnCenterApi.sendToWarnCenterWithReceive(warnList, Long.valueOf("584793299912114241"))).isSuccess()) continue;
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            this.logger.error("dutyEntity" + JSONObject.toJSONString((Object)((Object)dutyEntity)));
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u9884\u8b66\u6210\u529f");
    }

    private List<EarlyWarnTransVO> ctrl(List<DetailCacheEntity> detailCacheEntities, List<TotalCacheEntity> totalCacheEntities, Map<Long, RuleEntity> ruleMap, Map<String, List<RuleDetailEntity>> ruleDetailMap, DutyEntity dutyEntity, Map<Long, List<RuleReceiverEntity>> receiverMap, Map<String, String> scopeMap) {
        Long feeDetailId;
        HashSet<Long> feeDetailPkSet = new HashSet<Long>();
        for (TotalCacheEntity cacheEntity : totalCacheEntities) {
            feeDetailPkSet.add(cacheEntity.getFeeDetailId());
        }
        for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
            feeDetailPkSet.add(detailCacheEntity.getFeeDetailId());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, feeDetailPkSet);
        List feeDetalilist = this.feeDetailService.list((Wrapper)queryWrapper);
        Map<Long, String> innerCodeMap = feeDetalilist.stream().collect(Collectors.toMap(BaseEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        HashMap detailCacheMap = new HashMap();
        for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
            Long key;
            feeDetailId = detailCacheEntity.getFeeDetailId();
            List<RuleDetailEntity> ruleDetailEntityList = this.getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId));
            List<EarlyWarnTransVO> warnTransVOS = this.detailCtrl(ruleDetailEntityList, detailCacheEntity, dutyEntity, receiverMap, ruleMap);
            if (CollectionUtils.isNotEmpty(warnTransVOS)) {
                warnList.addAll(warnTransVOS);
            }
            List<DetailCacheEntity> list = detailCacheMap.containsKey(key = detailCacheEntity.getFeeDetailId()) ? (List)detailCacheMap.get(key) : new ArrayList();
            list.add(detailCacheEntity);
            detailCacheMap.put(key, list);
        }
        for (TotalCacheEntity cacheEntity : totalCacheEntities) {
            List<RuleDetailEntity> ruleNullList;
            List<EarlyWarnTransVO> warnTransVOList;
            feeDetailId = cacheEntity.getFeeDetailId();
            List detailCacheEntityList = (List)detailCacheMap.get(feeDetailId);
            List<RuleDetailEntity> ruleDetailEntityList = this.getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId));
            if (!CollectionUtils.isNotEmpty(ruleDetailEntityList)) continue;
            List<List<RuleDetailEntity>> ruleListAll = this.splitToMap(ruleDetailEntityList);
            List<RuleDetailEntity> ruleList = ruleListAll.get(0);
            List<EarlyWarnTransVO> warnTransVOS = this.totalCtrl(ruleList, false, cacheEntity, dutyEntity, detailCacheEntityList, receiverMap, ruleMap);
            if (CollectionUtils.isNotEmpty(warnTransVOS)) {
                warnList.addAll(warnTransVOS);
            }
            if (!CollectionUtils.isNotEmpty(warnTransVOList = this.totalCtrl(ruleNullList = ruleListAll.get(1), true, cacheEntity, dutyEntity, detailCacheEntityList, receiverMap, ruleMap))) continue;
            warnList.addAll(warnTransVOList);
        }
        return warnList;
    }

    private List<EarlyWarnTransVO> detailCtrl(List<RuleDetailEntity> ruleDetailEntityList, DetailCacheEntity detailCacheEntity, DutyEntity dutyEntity, Map<Long, List<RuleReceiverEntity>> receiverMap, Map<Long, RuleEntity> ruleMap) {
        ArrayList<EarlyWarnTransVO> list = new ArrayList<EarlyWarnTransVO>();
        if (CollectionUtils.isNotEmpty(ruleDetailEntityList)) {
            for (RuleDetailEntity ruleDetailEntity : ruleDetailEntityList) {
                BigDecimal controlScale;
                EarlyWarnTransVO earlyWarnTransVO;
                if (!receiverMap.containsKey(ruleDetailEntity.getId()) || null == (earlyWarnTransVO = this.dutyDetailRuleToWarnVO(detailCacheEntity, ruleDetailEntity, controlScale = ruleDetailEntity.getControlScale(), dutyEntity, receiverMap.get(ruleDetailEntity.getId()), ruleMap))) continue;
                list.add(earlyWarnTransVO);
            }
        }
        return list;
    }

    private List<EarlyWarnTransVO> totalCtrl(List<RuleDetailEntity> ruleList, Boolean isNullCtrl, TotalCacheEntity cacheEntity, DutyEntity dutyEntity, List<DetailCacheEntity> detailCacheEntities, Map<Long, List<RuleReceiverEntity>> receiverMap, Map<Long, RuleEntity> ruleMap) {
        ArrayList<EarlyWarnTransVO> list = new ArrayList<EarlyWarnTransVO>();
        if (CollectionUtils.isNotEmpty(ruleList)) {
            for (RuleDetailEntity ruleDetailEntity : ruleList) {
                BigDecimal controlScale;
                EarlyWarnTransVO earlyWarnTransVO;
                if (!receiverMap.containsKey(ruleDetailEntity.getId()) || null == (earlyWarnTransVO = this.dutyRuleToWarnVO(cacheEntity, ruleDetailEntity, controlScale = ruleDetailEntity.getControlScale(), dutyEntity, detailCacheEntities, isNullCtrl, receiverMap.get(ruleDetailEntity.getId()), ruleMap))) continue;
                list.add(earlyWarnTransVO);
            }
        }
        return list;
    }

    private EarlyWarnTransVO dutyRuleToWarnVO(TotalCacheEntity totalCacheEntity, RuleDetailEntity detailEntity, BigDecimal controlScale, DutyEntity dutyEntity, List<DetailCacheEntity> detailCacheEntities, Boolean isNullCtrl, List<RuleReceiverEntity> receiverEntities, Map<Long, RuleEntity> ruleMap) {
        ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
        if (CollectionUtils.isNotEmpty(receiverEntities)) {
            for (RuleReceiverEntity receiverEntity : receiverEntities) {
                WarningReceiveVO receiveVO = new WarningReceiveVO();
                receiveVO.setNameId(receiverEntity.getNameId());
                receiveVO.setName(receiverEntity.getName());
                receiveVO.setType(receiverEntity.getType());
                receiveVO.setWarningId(detailEntity.getId());
                receiveList.add(receiveVO);
            }
        }
        EarlyWarnTransVO vo = null;
        BigDecimal num = totalCacheEntity.getPreTypeAmount();
        BigDecimal costTaxMny = totalCacheEntity.getTaxMny();
        if (FeeTypeEnum.\u603b\u989d\u63a7.getCode().equals(detailEntity.getFeeType())) {
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            if (isNullCtrl.booleanValue()) {
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                    vo = new EarlyWarnTransVO();
                }
            } else if (null != costTaxMny && (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale))) {
                vo = new EarlyWarnTransVO();
            }
            if (null != vo) {
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
                vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("\u4e2d");
                vo.setWarnSetId(Long.valueOf("584793299912114241"));
                vo.setWarnSetParamId(Long.valueOf("584793299912114241"));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                vo.setEarlywarnName(totalCacheEntity.getName() + "\u603b\u989d\u63a7\u9884\u8b66");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u8ba1\u5212\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getPlanMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comPlanTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u5408\u540c\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getContTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comContTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u5165\u5e93\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comStoreTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u5176\u4ed6\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comOtherTaxScale, (int)2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        } else if (FeeTypeEnum.\u5206\u7c7b\u91cf\u63a7.getCode().equals(detailEntity.getFeeType())) {
            if (DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(totalCacheEntity.getDocType()) && totalCacheEntity.getLeafFlag().booleanValue()) {
                BigDecimal comPlanNum = null;
                BigDecimal comContNum = null;
                BigDecimal comStoreNum = null;
                BigDecimal comOtherNum = null;
                if (CollectionUtils.isNotEmpty(detailCacheEntities)) {
                    for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
                        comPlanNum = ComputeUtil.safeAdd(comPlanNum, (BigDecimal)detailCacheEntity.getPlanNum());
                        comContNum = ComputeUtil.safeAdd(comContNum, (BigDecimal)detailCacheEntity.getContNum());
                        comStoreNum = ComputeUtil.safeAdd(comStoreNum, (BigDecimal)detailCacheEntity.getStoreNum());
                        comOtherNum = ComputeUtil.safeAdd(comOtherNum, (BigDecimal)detailCacheEntity.getOtherNum());
                    }
                }
                BigDecimal comPlanScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv(comPlanNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L));
                BigDecimal comContScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv(comContNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L));
                BigDecimal comStoreScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv(comStoreNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L));
                BigDecimal comOtherScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv(comOtherNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L));
                if (isNullCtrl.booleanValue()) {
                    if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherScale)) {
                        vo = new EarlyWarnTransVO();
                    }
                } else if (null != num && (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherScale))) {
                    vo = new EarlyWarnTransVO();
                }
                if (null != vo) {
                    vo.setBillName(dutyEntity.getBillCode());
                    vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
                    vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
                    RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                    vo.setOrgId(ruleEntity.getOrgId());
                    vo.setOrgName(ruleEntity.getOrgName());
                    vo.setSourceId(String.valueOf(dutyEntity.getId()));
                    vo.setTenantId(dutyEntity.getTenantId());
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetId(Long.valueOf("584793299912114241"));
                    vo.setWarnSetParamId(Long.valueOf("584793299912114241"));
                    vo.setWarnType("1");
                    vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                    vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                    vo.setEarlywarnName(totalCacheEntity.getName() + "\u5206\u7c7b\u91cf\u63a7\u9884\u8b66");
                    vo.setReceiveList(receiveList);
                    StringBuffer warnStr = new StringBuffer();
                    if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanScale)) {
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("\u8ba1\u5212\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getPlanNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u6570\u91cf");
                        warnStr.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comPlanScale, (int)2)).append("%! \n");
                    }
                    if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContScale)) {
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("\u5408\u540c\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getContNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u6570\u91cf");
                        warnStr.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comContScale, (int)2)).append("%! \n");
                    }
                    if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreScale)) {
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("\u5165\u5e93\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getStoreNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u6570\u91cf");
                        warnStr.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comStoreScale, (int)2)).append("%! \n");
                    }
                    if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherScale)) {
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("\u5176\u4ed6\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOtherNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u6570\u91cf");
                        warnStr.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comOtherScale, (int)2)).append("%! \n");
                    }
                    vo.setEarlywarnContent(warnStr.toString());
                }
            }
        } else if (FeeTypeEnum.\u76ee\u6807\u5916\u660e\u7ec6\u603b\u91d1\u989d\u63a7.getCode().equals(detailEntity.getFeeType())) {
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getOutPlanTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getOutContTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getOutStoreTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)totalCacheEntity.getOutOtherTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            if (isNullCtrl.booleanValue()) {
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                    vo = new EarlyWarnTransVO();
                }
            } else if (null != costTaxMny && (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale))) {
                vo = new EarlyWarnTransVO();
            }
            if (null != vo) {
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
                vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("\u4e2d");
                vo.setWarnSetId(Long.valueOf("584793299912114241"));
                vo.setWarnSetParamId(Long.valueOf("584793299912114241"));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                vo.setEarlywarnName(totalCacheEntity.getName() + "\u76ee\u6807\u5916\u660e\u7ec6\u603b\u91d1\u989d\u63a7\u9884\u8b66");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u76ee\u6807\u5916\u660e\u7ec6\u8ba1\u5212\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOutPlanMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comPlanTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u76ee\u6807\u5916\u660e\u7ec6\u5408\u540c\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOutContTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comContTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u76ee\u6807\u5916\u660e\u7ec6\u5165\u5e93\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOutStoreTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comStoreTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("\u76ee\u6807\u5916\u660e\u7ec6\u5176\u4ed6\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)totalCacheEntity.getOutOtherTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comOtherTaxScale, (int)2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }
        return vo;
    }

    private List<List<RuleDetailEntity>> splitToMap(List<RuleDetailEntity> ruleDetailEntityList) {
        ArrayList<List<RuleDetailEntity>> resulte = new ArrayList<List<RuleDetailEntity>>();
        ArrayList<RuleDetailEntity> list = new ArrayList<RuleDetailEntity>();
        ArrayList<RuleDetailEntity> listNull = new ArrayList<RuleDetailEntity>();
        for (RuleDetailEntity entity : ruleDetailEntityList) {
            if (entity.getNullControlFlag().booleanValue()) {
                listNull.add(entity);
                continue;
            }
            list.add(entity);
        }
        resulte.add(list);
        resulte.add(listNull);
        return resulte;
    }

    private EarlyWarnTransVO dutyDetailRuleToWarnVO(DetailCacheEntity detailCacheEntity, RuleDetailEntity detailEntity, BigDecimal controlScale, DutyEntity dutyEntity, List<RuleReceiverEntity> receiverEntities, Map<Long, RuleEntity> ruleMap) {
        ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
        if (CollectionUtils.isNotEmpty(receiverEntities)) {
            for (RuleReceiverEntity receiverEntity : receiverEntities) {
                WarningReceiveVO receiveVO = new WarningReceiveVO();
                receiveVO.setNameId(receiverEntity.getNameId());
                receiveVO.setName(receiverEntity.getName());
                receiveVO.setType(receiverEntity.getType());
                receiveVO.setWarningId(detailEntity.getId());
                receiveList.add(receiveVO);
            }
        }
        EarlyWarnTransVO vo = null;
        BigDecimal costNum = detailCacheEntity.getAmount();
        BigDecimal costTaxMny = detailCacheEntity.getTaxMny();
        if (FeeTypeEnum.\u660e\u7ec6\u91d1\u989d\u63a7.getCode().equals(detailEntity.getFeeType())) {
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getPlanTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getContTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getStoreTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getOtherTaxMoney(), (BigDecimal)costTaxMny), (BigDecimal)BigDecimal.valueOf(100L));
            if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                vo = new EarlyWarnTransVO();
            }
            if (null != vo) {
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
                vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("\u4e2d");
                vo.setWarnSetId(Long.valueOf("584793299912114241"));
                vo.setWarnSetParamId(Long.valueOf("584793299912114241"));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + detailCacheEntity.getId());
                vo.setEarlywarnName(detailCacheEntity.getName() + "\u660e\u7ec6\u91d1\u989d\u63a7\u9884\u8b66");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanTaxScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u8ba1\u5212\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getPlanMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comPlanTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContTaxScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5408\u540c\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getContTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comContTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreTaxScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5165\u5e93\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getStoreTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comStoreTaxScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherTaxScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5176\u4ed6\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getOtherTaxMoney(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u91d1\u989d");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costTaxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comOtherTaxScale, (int)2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        } else if (FeeTypeEnum.\u660e\u7ec6\u91cf\u63a7.getCode().equals(detailEntity.getFeeType())) {
            BigDecimal comPlanScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getPlanNum(), (BigDecimal)costNum), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comContScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getContNum(), (BigDecimal)costNum), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comStoreScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getStoreNum(), (BigDecimal)costNum), (BigDecimal)BigDecimal.valueOf(100L));
            BigDecimal comOtherScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailCacheEntity.getOtherNum(), (BigDecimal)costNum), (BigDecimal)BigDecimal.valueOf(100L));
            if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreScale) || ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherScale)) {
                vo = new EarlyWarnTransVO();
            }
            if (null != vo) {
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
                vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("\u4e2d");
                vo.setWarnSetId(Long.valueOf("584793299912114241"));
                vo.setDef1(String.valueOf(detailEntity.getId()) + detailCacheEntity.getId());
                vo.setEarlywarnName(detailCacheEntity.getName() + "\u660e\u7ec6\u91cf\u63a7\u9884\u8b66");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comPlanScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u8ba1\u5212\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getPlanNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u6570\u91cf");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costNum, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comPlanScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comContScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5408\u540c\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getContNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u6570\u91cf");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costNum, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comContScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comStoreScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5165\u5e93\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getStoreNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u6570\u91cf");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costNum, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comStoreScale, (int)2)).append("%! \n");
                }
                if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comOtherScale)) {
                    warnStr.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("\u5176\u4ed6\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)detailCacheEntity.getOtherNum(), (int)2)).append(")\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6863\u6848\u6570\u91cf");
                    warnStr.append("(").append(ComputeUtil.scale((BigDecimal)costNum, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comOtherScale, (int)2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }
        return vo;
    }

    private List<RuleDetailEntity> getRuleDetailList(Map<String, List<RuleDetailEntity>> ruleDetailMap, String innerCode) {
        ArrayList<RuleDetailEntity> list = new ArrayList<RuleDetailEntity>();
        for (String key : ruleDetailMap.keySet()) {
            if (!innerCode.contains(key)) continue;
            List<RuleDetailEntity> ruleDetailEntities = ruleDetailMap.get(key);
            if (key.equals(innerCode)) {
                for (RuleDetailEntity detailEntity : ruleDetailEntities) {
                    list.add(detailEntity);
                }
                continue;
            }
            for (RuleDetailEntity detailEntity : ruleDetailEntities) {
                if (!FeeTypeEnum.\u660e\u7ec6\u91cf\u63a7.getCode().equals(detailEntity.getFeeType()) && !FeeTypeEnum.\u660e\u7ec6\u91d1\u989d\u63a7.getCode().equals(detailEntity.getFeeType())) continue;
                list.add(detailEntity);
            }
        }
        return list;
    }
}

