/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/execution/"})
public class ExecutionApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITotalExecutionService totalExecutionService;

    @PostMapping(value={"aggPush"})
    public CommonResponse<String> aggPush(@Valid @RequestBody ExecutionVO executionVO) {
        this.logger.error("aggPush vo is " + JSONObject.toJSONString((Object)executionVO));
        return this.totalExecutionService.aggPush(executionVO);
    }

    @PostMapping(value={"aggDel"})
    public CommonResponse<String> aggDel(@RequestBody List<TotalExecutionVO> totalExecutionVOList) {
        this.logger.error("aggDel voList is  " + JSONObject.toJSONString(totalExecutionVOList));
        return this.totalExecutionService.aggDel(totalExecutionVOList);
    }

    @PostMapping(value={"ctrlJson"})
    public CommonResponse<JSONObject> ctrlJson(@Valid @RequestBody ExecutionVO executionVO) {
        return this.totalExecutionService.ctrlJson(executionVO);
    }

    @PostMapping(value={"ctrlCheckVO"})
    public CommonResponse<ParamsCheckVO> ctrlCheckVO(@Valid @RequestBody ExecutionVO executionVO) {
        this.logger.error("before ctrl " + JSONObject.toJSONString((Object)executionVO));
        CommonResponse<JSONObject> response = this.totalExecutionService.ctrlJson(executionVO);
        this.logger.error("ctrl result " + JSONObject.toJSONString(response));
        return this.dealCtrlResult(response, "\u76ee\u6807\u6210\u672c\u63a7\u5236");
    }

    @PostMapping(value={"ctrlCost"})
    public CommonResponse<ParamsCheckVO> ctrlCost(@Valid @RequestBody CostCtrlVO costCtrlVO) {
        this.logger.error("before ctrl " + JSONObject.toJSONString((Object)costCtrlVO));
        CommonResponse<JSONObject> response = this.totalExecutionService.ctrlCost(costCtrlVO);
        this.logger.error("ctrl result " + JSONObject.toJSONString(response));
        return this.dealCtrlResult(response, "\u76ee\u6807\u6210\u672c\u6210\u672c\u79d1\u76ee\u63a7\u5236");
    }

    private CommonResponse<ParamsCheckVO> dealCtrlResult(CommonResponse<JSONObject> response, String warnItem) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        if (!response.isSuccess()) {
            if (null == response.getData()) {
                return CommonResponse.error((String)response.getMsg());
            }
            JSONObject jsonObject = (JSONObject)response.getData();
            Object obj = jsonObject.get((Object)ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode());
            if (null != obj) {
                String[] strings;
                for (String warn : strings = obj.toString().split("/n")) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[2]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(warnItem);
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
            }
            obj = jsonObject.get((Object)ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode());
            if (null != obj) {
                String[] strings;
                for (String warn : strings = obj.toString().split("/n")) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[1]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(warnItem);
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
            }
        } else if (null == response.getData()) {
            return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
        }
        paramsCheckVO.setWarnType(paramsArray[0]);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"queryTotalContMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalContMny(@RequestParam(value="projectId") Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(tax_money) as taxMoney"});
        queryWrapper.eq((Object)"bill_category", (Object)BillCategoryEnum.\u5408\u540c.getCode());
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)this.totalExecutionService.getOne((Wrapper)queryWrapper));
        return CommonResponse.success((String)"\u83b7\u53d6\u9879\u76ee\u7684\u5408\u540c\u603b\u989d\uff01", (Object)entity.getTaxMoney());
    }
}

